/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.config.LocaleMapping;

public class TestUtils {
    public static LocaleMapping createAndAddLocaleMapping(String localeId, Optional<String> optionalMapFrom, ConfigurableProjectOptions opts) {
        LocaleMapping mapping = new LocaleMapping(localeId);
        if (optionalMapFrom.isPresent()) {
            mapping.setMapFrom((String)optionalMapFrom.get());
        }
        opts.getLocaleMapList().add(mapping);
        return mapping;
    }

    public static String readFromClasspath(String relativePath) throws IOException {
        URL resource = TestUtils.loadFromClasspath(relativePath);
        return IOUtils.toString((URL)resource, (Charset)Charsets.UTF_8);
    }

    public static File fileFromClasspath(String relativePath) {
        try {
            URL url = TestUtils.loadFromClasspath(relativePath);
            File file = new File(url.toURI());
            assert (file.exists()) : "bad File from classpath URL: " + url;
            return file;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL loadFromClasspath(String relativePath) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(relativePath);
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (String)"%s not found", (Object[])new Object[]{relativePath});
        return resource;
    }
}

