/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.PutUserCommand;
import org.zanata.client.commands.PutUserOptions;
import org.zanata.client.commands.PutUserOptionsImpl;
import org.zanata.rest.client.AccountClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Account;

public class PutUserCommandTest {
    @Rule
    public ExpectedException expectException = ExpectedException.none();
    private final String username = "jcitizen";
    private final String key = "1234567890";
    @Mock
    private PutUserOptionsImpl opts;
    @Mock
    private AccountClient accountClient;
    @Mock
    private RestClientFactory restClientFactory;
    @Mock
    private PutUserCommand command;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new PutUserOptionsImpl();
        this.opts.setBatchMode(false);
        this.opts.setUsername("admin");
        this.opts.setKey("1234567890");
        this.opts.setUrl(new URL("http://localhost:8080/zanata"));
        Mockito.when((Object)this.restClientFactory.getAccountClient()).thenReturn((Object)this.accountClient);
        ((RestClientFactory)Mockito.doNothing().when((Object)this.restClientFactory)).performVersionCheck();
    }

    @Test
    public void testValidUserAccountCreate() throws Exception {
        Account expected = new Account();
        expected.setUsername("jcitizen");
        this.opts.setUserUsername("jcitizen");
        expected.setApiKey("1234567890");
        this.opts.setUserKey("1234567890");
        expected.setEmail("email@example.com");
        this.opts.setUserEmail("email@example.com");
        expected.setName("James");
        this.opts.setUserName("James");
        expected.setEnabled(true);
        ConsoleInteractor consoleInteractor = MockConsoleInteractor.predefineAnswers("y");
        this.command = new PutUserCommand((PutUserOptions)this.opts, this.restClientFactory, consoleInteractor);
        this.command.run();
        ((RestClientFactory)Mockito.verify((Object)this.restClientFactory, (VerificationMode)Mockito.times((int)2))).getAccountClient();
        ((AccountClient)Mockito.verify((Object)this.accountClient)).put("jcitizen", expected);
    }

    @Test
    public void testValidUserAccountUpdate() throws Exception {
        Account existing = this.getGenericAccount();
        this.opts.setUserUsername("jcitizen");
        Mockito.when((Object)this.accountClient.get("jcitizen")).thenReturn((Object)existing);
        existing.setEmail("jane@example.com");
        this.opts.setUserEmail("jane@example.com");
        existing.setName("James");
        this.opts.setUserName("Jane");
        existing.setEnabled(false);
        this.opts.setUserEnabled("false");
        existing.setRoles(new HashSet<String>(Arrays.asList("user", "glossarist")));
        this.opts.setUserRoles("user,glossarist");
        existing.setTribes(new HashSet<String>(Arrays.asList("en-AU", "ru")));
        this.opts.setUserLangs("en-AU,ru");
        ConsoleInteractor consoleInteractor = MockConsoleInteractor.predefineAnswers("y");
        this.command = new PutUserCommand((PutUserOptions)this.opts, this.restClientFactory, consoleInteractor);
        this.command.run();
        ((RestClientFactory)Mockito.verify((Object)this.restClientFactory, (VerificationMode)Mockito.times((int)2))).getAccountClient();
        ((AccountClient)Mockito.verify((Object)this.accountClient)).put("jcitizen", existing);
    }

    @Test
    public void newUserNameAndEmailRequired() throws Exception {
        this.opts.setUserName(null);
        this.opts.setUserEmail("test@test.com");
        this.command = new PutUserCommand((PutUserOptions)this.opts, this.restClientFactory);
        this.expectException.expect(RuntimeException.class);
        this.expectException.expectMessage("New user's name and email must be specified");
        this.command.run();
        this.opts.setUserName("username");
        this.opts.setUserEmail(null);
        this.command = new PutUserCommand((PutUserOptions)this.opts, this.restClientFactory);
        this.expectException.expect(RuntimeException.class);
        this.expectException.expectMessage("New user's name and email must be specified");
        this.command.run();
    }

    private Account getGenericAccount() {
        Account existing = new Account("jcitizen@example.com", "John Citizen", "jcitizen", "UZMf4PIqtTBGAo9wWKuTpg==");
        existing.setEnabled(true);
        existing.setApiKey("0987654321234567890");
        existing.setRoles(new HashSet<String>(Arrays.asList("user")));
        existing.setTribes(new HashSet<String>(Arrays.asList("en-AU")));
        return existing;
    }
}

