/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.AsyncProcessClient;
import org.zanata.rest.client.CopyTransClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.client.SourceDocResourceClient;
import org.zanata.rest.dto.CopyTransStatus;
import org.zanata.rest.dto.ProcessStatus;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PushCommandTest {
    @Mock
    private RestClientFactory clientFactory;
    @Mock
    private SourceDocResourceClient sourceDocResourceClient;
    @Mock
    private AsyncProcessClient asyncProcessClient;
    @Mock
    private CopyTransClient copyTransClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.clientFactory.getSourceDocResourceClient(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.sourceDocResourceClient);
        Mockito.when((Object)this.clientFactory.getAsyncProcessClient()).thenReturn((Object)this.asyncProcessClient);
        Mockito.when((Object)this.clientFactory.getCopyTransClient()).thenReturn((Object)this.copyTransClient);
    }

    @Test
    public void pushSrc() throws Exception {
        this.push(false, false);
    }

    @Test
    public void pushSrcAndTarget() throws Exception {
        this.push(true, false);
    }

    @Test
    public void pushSrcAndTargetWithLocaleMapping() throws Exception {
        this.push(true, true);
    }

    @Test
    public void testSplitTranslationResource() throws Exception {
        int batchSize = 100;
        int listSize = 500;
        this.checkSplitResult(listSize, batchSize);
        batchSize = 50;
        listSize = 500;
        this.checkSplitResult(listSize, batchSize);
    }

    @Test
    public void testSplitTranslationResourceWithMod() throws Exception {
        int batchSize = 100;
        int listSize = 505;
        this.checkSplitResult(listSize, batchSize);
        batchSize = 100;
        listSize = 510;
        this.checkSplitResult(listSize, batchSize);
    }

    private void checkSplitResult(int listSize, int batchSize) throws Exception {
        int expectLastTftSize;
        PushCommand cmd = this.generatePushCommand(true, true);
        TranslationsResource transRes = new TranslationsResource();
        for (int i = 0; i < listSize; ++i) {
            transRes.getTextFlowTargets().add(new TextFlowTarget(String.valueOf(i)));
        }
        List list = cmd.splitIntoBatch(transRes, batchSize);
        int expectListSize = listSize / batchSize;
        if (listSize % batchSize != 0) {
            ++expectListSize;
        }
        if ((expectLastTftSize = listSize % batchSize) == 0) {
            expectLastTftSize = batchSize;
        }
        Assert.assertEquals((long)list.size(), (long)expectListSize);
        Assert.assertEquals((long)((TranslationsResource)list.get(0)).getTextFlowTargets().size(), (long)batchSize);
        Assert.assertEquals((long)((TranslationsResource)list.get(list.size() - 1)).getTextFlowTargets().size(), (long)expectLastTftSize);
    }

    private PushCommand generatePushCommand(boolean pushTrans, boolean mapLocale) throws Exception {
        PushOptionsImpl opts = new PushOptionsImpl();
        opts.setInteractiveMode(false);
        String projectSlug = "project";
        opts.setProj(projectSlug);
        String versionSlug = "1.0";
        opts.setProjectVersion(versionSlug);
        opts.setSrcDir(TestUtils.fileFromClasspath("test1/pot"));
        if (pushTrans) {
            opts.setPushType("both");
        } else {
            opts.setPushType("source");
        }
        opts.setTransDir(TestUtils.fileFromClasspath("test1"));
        opts.setProjectType("podir");
        opts.setCopyTrans(true);
        opts.setIncludes("**/*.pot");
        opts.setExcludes("");
        opts.setSourceLang("en-US");
        opts.setMergeType("auto");
        LocaleList locales = new LocaleList();
        if (mapLocale) {
            locales.add(new LocaleMapping("ja", "ja-JP"));
        } else {
            locales.add(new LocaleMapping("ja-JP"));
        }
        opts.setLocaleMapList(locales);
        OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
        return new PushCommand((PushOptions)opts, this.clientFactory.getCopyTransClient(), this.clientFactory.getAsyncProcessClient(), this.clientFactory);
    }

    private void push(boolean pushTrans, boolean mapLocale) throws Exception {
        ArrayList<ResourceMeta> resourceMetaList = new ArrayList<ResourceMeta>();
        resourceMetaList.add(new ResourceMeta("obsolete"));
        resourceMetaList.add(new ResourceMeta("RPM"));
        Mockito.when((Object)this.sourceDocResourceClient.getResourceMeta(null)).thenReturn(resourceMetaList);
        Mockito.when((Object)this.sourceDocResourceClient.deleteResource("obsolete")).thenReturn(null);
        StringSet extensionSet = new StringSet("gettext;comment");
        ProcessStatus mockStatus = new ProcessStatus();
        mockStatus.setStatusCode(ProcessStatus.ProcessStatusCode.Finished);
        mockStatus.setMessages(new ArrayList());
        Mockito.when((Object)this.asyncProcessClient.startSourceDocCreationOrUpdate((String)Matchers.eq((Object)"RPM"), Matchers.anyString(), Matchers.anyString(), (Resource)Matchers.any(Resource.class), (Set)Matchers.eq((Object)extensionSet), Matchers.eq((boolean)false))).thenReturn((Object)mockStatus);
        Mockito.when((Object)this.asyncProcessClient.startSourceDocCreationOrUpdate((String)Matchers.eq((Object)"sub,RPM"), Matchers.anyString(), Matchers.anyString(), (Resource)Matchers.any(Resource.class), (Set)Matchers.eq((Object)extensionSet), Matchers.eq((boolean)false))).thenReturn((Object)mockStatus);
        Mockito.when((Object)this.asyncProcessClient.getProcessStatus(Matchers.anyString())).thenReturn((Object)mockStatus);
        CopyTransStatus mockCopyTransStatus = new CopyTransStatus();
        mockCopyTransStatus.setInProgress(false);
        mockCopyTransStatus.setPercentageComplete(100);
        Mockito.when((Object)this.copyTransClient.getCopyTransStatus(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)mockCopyTransStatus);
        if (pushTrans) {
            LocaleId expectedLocale = mapLocale ? new LocaleId("ja") : new LocaleId("ja-JP");
            Mockito.when((Object)this.asyncProcessClient.startTranslatedDocCreationOrUpdate((String)Matchers.eq((Object)"RPM"), Matchers.anyString(), Matchers.anyString(), (LocaleId)Matchers.eq((Object)expectedLocale), (TranslationsResource)Matchers.any(TranslationsResource.class), (Set)Matchers.eq((Object)extensionSet), (String)Matchers.eq((Object)"auto"), Matchers.eq((boolean)false))).thenReturn((Object)mockStatus);
        }
        PushCommand cmd = this.generatePushCommand(pushTrans, mapLocale);
        cmd.runWithActions();
    }
}

