/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableOptionsImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.PutUserCommand;
import org.zanata.client.commands.PutUserOptions;

public class PutUserOptionsImpl
extends ConfigurableOptionsImpl
implements PutUserOptions {
    private String userName;
    private String userEmail;
    private String userUsername;
    private String userPasswordHash;
    private String userKey;
    private String userRoles;
    private String userLangs;
    private String userEnabled = "auto";
    private static final Logger log = LoggerFactory.getLogger(PutUserCommand.class);

    @Override
    public String getCommandName() {
        return "put-user";
    }

    @Override
    public String getCommandDescription() {
        return Messages.get("command.description.put-user");
    }

    @Override
    public PutUserCommand initCommand() {
        return new PutUserCommand(this);
    }

    @Override
    @Option(name="--user-name", usage="Full name of the user (required for new user)")
    public void setUserName(String name) {
        this.userName = name;
    }

    @Override
    @Option(name="--user-email", usage="Email address of the user (required for new user)")
    public void setUserEmail(String email) {
        this.userEmail = email;
    }

    @Override
    @Option(name="--user-username", required=true, usage="Login/username of the user (required)")
    public void setUserUsername(String username) {
        this.userUsername = username;
    }

    @Override
    @Option(name="--user-passwordhash", usage="User password hash")
    public void setUserPasswordHash(String passwordHash) {
        this.userPasswordHash = passwordHash;
    }

    @Override
    @Option(name="--user-key", usage="User's api key (empty for none)")
    public void setUserKey(String userKey) {
        this.userKey = StringUtils.isBlank((CharSequence)userKey) ? null : userKey;
    }

    @Override
    @Option(name="--user-langs", usage="Language teams for the user")
    public void setUserLangs(String userLangs) {
        this.userLangs = userLangs;
    }

    @Override
    @Option(name="--user-roles", usage="Security roles for the user")
    public void setUserRoles(String roles) {
        this.userRoles = roles;
    }

    @Override
    @Option(name="--user-enabled", usage="Enable or disable the user (true, false, auto). Defaults to auto: new users will be enabled, existing users will stay enabled/disabled (ie no change)")
    public void setUserEnabled(String enabled) {
        String[] options = new String[]{"auto", "true", "false"};
        if (!Arrays.asList(options).contains(enabled.toLowerCase())) {
            throw new RuntimeException("--user-enabled requires true or false (or auto)");
        }
        this.userEnabled = enabled.toLowerCase();
    }

    @Override
    public String getUserUsername() {
        return this.userUsername;
    }

    @Override
    public String isUserEnabled() {
        return this.userEnabled;
    }

    @Override
    public String getUserLangs() {
        return this.userLangs;
    }

    @Override
    public String getUserKey() {
        return this.userKey;
    }

    @Override
    public String getUserPasswordHash() {
        return this.userPasswordHash;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getUserEmail() {
        return this.userEmail;
    }

    @Override
    public String getUserRoles() {
        return this.userRoles;
    }
}

