/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DataConfiguration;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.init.InitOptions;

class UserConfigHandler {
    private static final Logger log = LoggerFactory.getLogger(UserConfigHandler.class);
    private final ConsoleInteractor consoleInteractor;
    private final InitOptions opts;

    public UserConfigHandler(ConsoleInteractor consoleInteractor, InitOptions opts) {
        this.consoleInteractor = consoleInteractor;
        this.opts = opts;
    }

    @VisibleForTesting
    protected void verifyUserConfig() throws Exception {
        File userConfig = this.opts.getUserConfig();
        if (!userConfig.exists()) {
            throw new RuntimeException(Messages.get("missing.user.config"));
        }
        this.clearValueSetByConfigurableMojo();
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration(this.opts.getUserConfig());
        List<URL> serverUrls = this.readServerUrlsFromUserConfig(config);
        if (serverUrls.isEmpty()) {
            String msg = Messages.get("missing.server.url");
            log.warn(msg);
            throw new RuntimeException(msg);
        }
        if (serverUrls.size() == 1) {
            this.opts.setUrl(serverUrls.get(0));
        } else {
            this.consoleInteractor.printfln(Messages.get("found.servers"), this.opts.getUserConfig().getName());
            List<String> answers = this.listServerUrlsPrefixedWithNumber(serverUrls);
            this.consoleInteractor.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("which.server"), new Object[0]);
            String chosenNumber = this.consoleInteractor.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.expect(answers));
            URL url = serverUrls.get(Integer.parseInt(chosenNumber) - 1);
            this.consoleInteractor.printfln(ConsoleInteractor.DisplayMode.Confirmation, Messages.get("server.selection"), url);
            this.opts.setUrl(url);
        }
        OptionsUtil.applyUserConfig(this.opts, config);
    }

    private void clearValueSetByConfigurableMojo() {
        this.opts.setUsername(null);
        this.opts.setUrl(null);
        this.opts.setKey(null);
    }

    private List<URL> readServerUrlsFromUserConfig(HierarchicalINIConfiguration config) throws ConfigurationException {
        SubnodeConfiguration servers = config.getSection("servers");
        DataConfiguration dataConfig = new DataConfiguration((Configuration)servers);
        ArrayList serverUrls = Lists.newArrayList();
        Iterator iterator = dataConfig.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.endsWith(".url")) continue;
            serverUrls.add(dataConfig.get(URL.class, key));
        }
        return serverUrls;
    }

    private List<String> listServerUrlsPrefixedWithNumber(List<URL> serverUrls) {
        ArrayList answers = Lists.newArrayList();
        for (int i = 0; i < serverUrls.size(); ++i) {
            URL serverUrl = serverUrls.get(i);
            int number = i + 1;
            this.consoleInteractor.printf("%d)", number).printfln(ConsoleInteractor.DisplayMode.Hint, serverUrl.toString(), new Object[0]);
            answers.add(number + "");
        }
        return answers;
    }

    public InitOptions getOpts() {
        return this.opts;
    }
}

