/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.Console;
import java.io.IOException;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.config.CommandHook;
import org.zanata.rest.client.RestClientFactory;

public abstract class ConfigurableCommand<O extends ConfigurableOptions>
implements ZanataCommand {
    private final O opts;
    private RestClientFactory clientFactory;
    private boolean deprecated;
    private String deprecationMessage;
    private static final Logger log = LoggerFactory.getLogger(ConfigurableCommand.class);

    public ConfigurableCommand(O opts, RestClientFactory clientFactory) {
        this.opts = opts;
        this.clientFactory = clientFactory == null ? OptionsUtil.createClientFactory(opts) : clientFactory;
    }

    public ConfigurableCommand(O opts) {
        this(opts, null);
    }

    @Deprecated
    protected static void expectYes(Console console) throws IOException {
        String line = console.readLine();
        if (line == null) {
            throw new IOException("console stream closed");
        }
        if (!line.toLowerCase().equals("y") && !line.toLowerCase().equals("yes")) {
            throw new RuntimeException("operation aborted by user");
        }
    }

    public O getOpts() {
        return this.opts;
    }

    public RestClientFactory getClientFactory() {
        return this.clientFactory;
    }

    protected final void setClientFactory(RestClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public String getDeprecationMessage() {
        return this.deprecationMessage;
    }

    public void deprecate(String deprecationMessage) {
        this.deprecated = true;
        this.deprecationMessage = deprecationMessage;
    }

    @Override
    public String getName() {
        return this.opts.getCommandName();
    }

    @Override
    public void runWithActions() throws Exception {
        this.runBeforeActions();
        this.run();
        this.runAfterActions();
    }

    protected abstract void run() throws Exception;

    private void runBeforeActions() throws Exception {
        for (CommandHook hook : this.getOpts().getCommandHooks()) {
            if (!this.isForThisCommand(hook)) continue;
            this.runSystemCommands(hook.getBefores());
        }
    }

    private void runAfterActions() throws Exception {
        for (CommandHook hook : this.getOpts().getCommandHooks()) {
            if (!this.isForThisCommand(hook)) continue;
            this.runSystemCommands(hook.getAfters());
        }
    }

    private void runSystemCommands(List<String> commands) throws Exception {
        for (String command : commands) {
            log.info("[Running command]$ " + command);
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
                CommandLine cmdLine = CommandLine.parse((String)command);
                int exitValue = executor.execute(cmdLine);
                if (exitValue != 0) {
                    throw new Exception("Command returned non-zero exit value: " + exitValue);
                }
                log.info("    Completed with exit value: " + exitValue);
            }
            catch (IOException e) {
                throw new Exception("Failed to run command. " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new Exception("Interrupted while running command. " + e.getMessage(), e);
            }
        }
    }

    private boolean isForThisCommand(CommandHook hook) {
        return this.getName().equals(hook.getCommand());
    }
}

