/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Optional;
import java.io.File;
import java.util.EnumMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.DocNameWithExt;
import org.zanata.client.commands.FileMappingRuleHandler;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;

public class FileMappingRuleHandlerTest {
    private ConfigurableProjectOptions opts = new PushOptionsImpl();

    @Test
    public void canCheckSyntaxErrorInTheRule() {
        MatcherAssert.assertThat((String)"unbalanced brace", (Object)FileMappingRuleHandler.isRuleValid((String)"{a"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"unbalanced brace", (Object)FileMappingRuleHandler.isRuleValid((String)"a}"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"missing brace", (Object)FileMappingRuleHandler.isRuleValid((String)"a"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"invalid placeholder", (Object)FileMappingRuleHandler.isRuleValid((String)"{a}"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"missing mandatory placeholder", (Object)FileMappingRuleHandler.isRuleValid((String)"{path}"), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)FileMappingRuleHandler.isRuleValid((String)"{path}/{locale_with_underscore}.po"), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)FileMappingRuleHandler.isRuleValid((String)"{path}/../{locale}/{filename}.po"), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void willReturnTransFileRelativePath() {
        MatcherAssert.assertThat((Object)this.getTransFile("pot/message.pot", "fr", "{path}/../{locale}/{filename}.po"), (Matcher)Matchers.equalTo((Object)"fr/message.po"));
        MatcherAssert.assertThat((Object)this.getTransFile("./message.pot", "fr", "{path}/{locale_with_underscore}.po"), (Matcher)Matchers.equalTo((Object)"fr.po"));
        MatcherAssert.assertThat((Object)this.getTransFile("a/path/message.odt", "de-DE", "{path}/{locale_with_underscore}_{filename}.{extension}"), (Matcher)Matchers.equalTo((Object)"a/path/de_DE_message.odt"));
    }

    @Test
    public void ifNoPatternWillUseProjectType() {
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule(null, "{path}/{locale_with_underscore}.po"), this.opts);
        MatcherAssert.assertThat((Object)handler.getRelativeTransFilePathForSourceDoc(DocNameWithExt.from((String)"message.pot"), new LocaleMapping("zh"), Optional.absent()), (Matcher)Matchers.equalTo((Object)"zh.po"));
    }

    private String getTransFile(String sourceFile, String locale, String rule) {
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule("**/*", rule), this.opts);
        return handler.getRelativeTransFilePathForSourceDoc(DocNameWithExt.from((String)sourceFile), new LocaleMapping(locale), Optional.absent());
    }

    @Test
    public void canGetPartsFromFullFilename() {
        EnumMap map = FileMappingRuleHandler.parseToMap((String)"foo/message.pot", (LocaleMapping)new LocaleMapping("zh-CN", "zh-Hans"), (Optional)Optional.absent());
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.path, (Object)"foo"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.filename, (Object)"message"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.extension, (Object)"pot"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.locale, (Object)"zh-Hans"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.localeWithUnderscore, (Object)"zh_Hans"));
    }

    @Test
    public void canGetPartsFromFullFilename2() {
        EnumMap map = FileMappingRuleHandler.parseToMap((String)"foo/message.pot", (LocaleMapping)new LocaleMapping("zh-CN", "zh-Hans"), (Optional)Optional.of((Object)"po"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.path, (Object)"foo"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.filename, (Object)"message"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.extension, (Object)"po"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.locale, (Object)"zh-Hans"));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)FileMappingRuleHandler.Placeholders.localeWithUnderscore, (Object)"zh_Hans"));
    }

    @Test
    public void canTestApplicable() {
        this.opts.setSrcDir(new File("."));
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule("**/*.odt", "{locale}/{filename}.{extension}"), this.opts);
        MatcherAssert.assertThat((Object)handler.isApplicable(DocNameWithExt.from((String)"test/doc.odt")), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)handler.isApplicable(DocNameWithExt.from((String)"test/doc.pot")), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)handler.isApplicable(DocNameWithExt.from((String)"doc.pot")), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)handler.isApplicable(DocNameWithExt.from((String)"doc.odt")), (Matcher)Matchers.equalTo((Object)true));
    }
}

