/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import org.fedorahosted.openprops.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.HTTPMockContainer;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.UpdateChecker;

public class UpdateCheckerTest {
    private final DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private final String currentVersion = "3.0.1";
    @Rule
    public TemporaryFolder tempFoler = new TemporaryFolder();
    private UpdateChecker checker;
    private Connection connection;
    @Mock
    private ConsoleInteractor mockConsole;
    @Captor
    private ArgumentCaptor<String> outputStringCaptor;
    @Captor
    private ArgumentCaptor<Object> outputArgsCaptor;
    private File marker;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        File configFolder = this.tempFoler.newFolder();
        this.marker = new File(configFolder, "zanata-client-update");
        this.checker = new UpdateChecker("http://localhost", this.marker, this.mockConsole, "3.0.1");
    }

    @After
    public void cleanUp() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void noMarkerFileYetWillCreateFileAndCheckUpdate() throws Exception {
        boolean result = this.checker.needToCheckUpdates(true);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.marker.exists(), (Matcher)Matchers.is((Object)true));
        Properties properties = new Properties();
        properties.load((Reader)new FileReader(this.marker));
        String today = this.dateFormat.print((ReadableInstant)new DateTime());
        MatcherAssert.assertThat((Object)properties.getProperty("lastChecked"), (Matcher)Matchers.equalTo((Object)today));
        MatcherAssert.assertThat((Object)properties.getProperty("frequency"), (Matcher)Matchers.equalTo((Object)"weekly"));
        MatcherAssert.assertThat((Object)properties.getComment("frequency"), (Matcher)Matchers.equalTo((Object)Messages.get((String)"valid.frequency")));
    }

    @Test
    public void willNotCheckIfUserSaysNo() throws Exception {
        String sevenDaysAgo = this.dateFormat.print((ReadableInstant)new DateTime().minusDays(7));
        this.writeLinesToMarkerFile("lastChecked=" + sevenDaysAgo, "noAsking=false");
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("n");
        this.checker = new UpdateChecker("localhost", this.marker, console, "3.3.3");
        boolean result = this.checker.needToCheckUpdates(true);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void byDefaultMarkerFileHasLastCheckedDateOverOneWeekWillCheck() throws Exception {
        String sevenDaysAgo = this.dateFormat.print((ReadableInstant)new DateTime().minusDays(7));
        this.writeLinesToMarkerFile("lastChecked=" + sevenDaysAgo);
        Mockito.when((Object)this.mockConsole.expectAnswerWithRetry(ConsoleInteractor.AnswerValidator.YES_NO)).thenReturn((Object)"y");
        boolean result = this.checker.needToCheckUpdates(true);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void byDefaultMarkerFileHasLastCheckedDateWithinOneWeekWillNotCheck() throws Exception {
        String twoDaysAgo = this.dateFormat.print((ReadableInstant)new DateTime().minusDays(2));
        this.writeLinesToMarkerFile("lastChecked=" + twoDaysAgo);
        boolean result = this.checker.needToCheckUpdates(true);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void canConfigureCheckFrequency() throws Exception {
        String twoDaysAgo = this.dateFormat.print((ReadableInstant)new DateTime().minusDays(2));
        this.writeLinesToMarkerFile("lastChecked=" + twoDaysAgo, "frequency=daily");
        Mockito.when((Object)this.mockConsole.expectAnswerWithRetry(ConsoleInteractor.AnswerValidator.YES_NO)).thenReturn((Object)"y");
        boolean result = this.checker.needToCheckUpdates(true);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
    }

    private void writeLinesToMarkerFile(String ... lines) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(Files.newWriter((File)this.marker, (Charset)Charsets.UTF_8));
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            writer.println(line);
            ++n2;
        }
        writer.close();
    }

    @Test
    public void canCheckForUpdates() throws Exception {
        HTTPMockContainer container = HTTPMockContainer.Builder.builder().onPathReturnOk((Matcher<String>)Matchers.endsWith((String)"/artifact/maven/resolve"), "<artifact-resolution><version>3.3.2</version></artifact-resolution>").build();
        String url = this.startMockServer(container);
        String sevenDaysAgo = this.dateFormat.print((ReadableInstant)new DateTime().minusDays(7));
        this.writeLinesToMarkerFile("lastChecked=" + sevenDaysAgo);
        this.checker = new UpdateChecker(url, this.marker, this.mockConsole, "3.0.1");
        this.checker.checkNewerVersion();
        String expectedString = Messages.get((String)"suggest.update");
        ((ConsoleInteractor)Mockito.verify((Object)this.mockConsole, (VerificationMode)Mockito.atLeastOnce())).printfln((String)this.outputStringCaptor.capture(), new Object[]{this.outputArgsCaptor.capture()});
        List allValues = this.outputStringCaptor.getAllValues();
        String lastMessage = (String)allValues.get(allValues.size() - 1);
        MatcherAssert.assertThat((Object)lastMessage, (Matcher)Matchers.equalTo((Object)expectedString));
        MatcherAssert.assertThat((Object)this.outputArgsCaptor.getAllValues(), (Matcher)Matchers.contains((Object[])new Object[]{"3.3.2"}));
        Properties props = new Properties();
        props.load((Reader)new FileReader(this.marker));
        MatcherAssert.assertThat((Object)props.getProperty("lastChecked"), (Matcher)Matchers.equalTo((Object)this.dateFormat.print((ReadableInstant)new DateTime())));
    }

    private String startMockServer(Container container) throws IOException {
        ContainerServer server = new ContainerServer(container);
        this.connection = new SocketConnection((Server)server);
        InetSocketAddress address = (InetSocketAddress)this.connection.connect((SocketAddress)new InetSocketAddress(0));
        int port = address.getPort();
        return "http://localhost:" + port + "/";
    }
}

