/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.integration;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.MockServerRule;
import org.zanata.client.TestProjectGenerator;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.pull.RawPullCommand;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.integration.PushPullGettextITCase;
import org.zanata.common.ProjectType;
import org.zanata.rest.dto.resource.ResourceMeta;

public class PushPullFileProjectITCase {
    private static final Logger log = LoggerFactory.getLogger(PushPullGettextITCase.class);
    @Rule
    public MockServerRule mockServerRule = new MockServerRule();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private TestProjectGenerator testProjectGenerator = new TestProjectGenerator();

    @Before
    public void setUp() {
        PullOptionsImpl pullOpts = this.mockServerRule.getPullOpts();
        pullOpts.getLocaleMapList().add(new LocaleMapping("zh-CN"));
        pullOpts.setProjectType("file");
        PushOptionsImpl pushOpts = this.mockServerRule.getPushOpts();
        pushOpts.getLocaleMapList().add(new LocaleMapping("zh-CN"));
        pushOpts.setProjectType("file");
    }

    @Test
    public void pushFileTypeProject() throws Exception {
        PushOptionsImpl opts = this.mockServerRule.getPushOpts();
        opts.setPushType("both");
        File baseDir = this.testProjectGenerator.getProjectBaseDir(ProjectType.File);
        log.debug("testing project is at: {}", (Object)baseDir);
        opts.setFileTypes("odt,ods");
        opts.setSrcDir(new File(baseDir, "src"));
        opts.setTransDir(baseDir);
        RawPushCommand pushCommand = this.mockServerRule.createRawPushCommand();
        pushCommand.run();
        this.mockServerRule.verifyPushRawFileSource(2);
        MatcherAssert.assertThat((Object)this.mockServerRule.getDocIdCaptor().getAllValues(), (Matcher)Matchers.contains((Object[])new String[]{"test-ods.ods", "test-odt.odt"}));
        this.mockServerRule.verifyPushRawFileTranslation(1);
        MatcherAssert.assertThat((Object)((String)this.mockServerRule.getDocIdCaptor().getValue()), (Matcher)Matchers.equalTo((Object)"test-odt.odt"));
    }

    @Test
    public void pushFileProjectUsingFileMapping() throws Exception {
        PushOptionsImpl opts = this.mockServerRule.getPushOpts();
        opts.setPushType("trans");
        File baseDir = this.testProjectGenerator.getProjectBaseDir(ProjectType.File);
        log.debug("testing project is at: {}", (Object)baseDir);
        opts.setFileTypes("odt,ods");
        opts.setSrcDir(new File(baseDir, "src"));
        opts.setTransDir(baseDir);
        opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("{locale}/{path}/{filename}.{extension}")}));
        RawPushCommand pushCommand = this.mockServerRule.createRawPushCommand();
        pushCommand.run();
        this.mockServerRule.verifyPushRawFileTranslation(1);
        MatcherAssert.assertThat((Object)((String)this.mockServerRule.getDocIdCaptor().getValue()), (Matcher)Matchers.equalTo((Object)"test-odt.odt"));
    }

    @Test
    public void pullFileProject() throws Exception {
        PullOptionsImpl opts = this.mockServerRule.getPullOpts();
        opts.setPullType("both");
        File pullBaseDir = this.tempFolder.newFolder("file-pull-test");
        opts.setSrcDir(pullBaseDir);
        opts.setTransDir(pullBaseDir);
        log.debug("pull base dir is: {}", (Object)pullBaseDir);
        InputStream sourceFileStream = IOUtils.toInputStream((String)"source content", (Charset)StandardCharsets.UTF_8);
        InputStream transFileStream = IOUtils.toInputStream((String)"translation content", (Charset)StandardCharsets.UTF_8);
        ArrayList remoteDocList = Lists.newArrayList((Object[])new ResourceMeta[]{new ResourceMeta("test-ods.ods"), new ResourceMeta("test-odt.odt")});
        RawPullCommand pullCommand = this.mockServerRule.createRawPullCommand(remoteDocList, sourceFileStream, transFileStream);
        pullCommand.run();
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "test-ods.ods").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "test-odt.odt").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "zh-CN/test-odt.odt").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "zh-CN/test-ods.ods").exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void pullFileProjectUsingFileMapping() throws Exception {
        PullOptionsImpl opts = this.mockServerRule.getPullOpts();
        opts.setPullType("trans");
        File pullBaseDir = this.tempFolder.newFolder("file-pull-test");
        opts.setSrcDir(pullBaseDir);
        opts.setTransDir(pullBaseDir);
        log.debug("pull base dir is: {}", (Object)pullBaseDir);
        opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("**/*.odt", "{extension}/{path}/{locale}/{filename}.{extension}"), new FileMappingRule("**/*.ods", "{extension}/{locale_with_underscore}/{filename}.{extension}")}));
        InputStream sourceFileStream = IOUtils.toInputStream((String)"source content", (Charset)StandardCharsets.UTF_8);
        InputStream transFileStream = IOUtils.toInputStream((String)"translation content", (Charset)StandardCharsets.UTF_8);
        ArrayList remoteDocList = Lists.newArrayList((Object[])new ResourceMeta[]{new ResourceMeta("test-ods.ods"), new ResourceMeta("test-odt.odt")});
        RawPullCommand pullCommand = this.mockServerRule.createRawPullCommand(remoteDocList, sourceFileStream, transFileStream);
        pullCommand.run();
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "odt/zh-CN/test-odt.odt").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(pullBaseDir, "ods/zh_CN/test-ods.ods").exists(), (Matcher)Matchers.is((Object)true));
    }
}

