/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.IOException;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.PutUserOptionsImpl;

public class PutUserOptionsImplTest {
    @Rule
    public ExpectedException expectException = ExpectedException.none();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private PutUserOptionsImpl opts;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new PutUserOptionsImpl();
        this.opts.setUsername("jcitizen");
        this.opts.setKey("1234567890");
        this.opts.setUrl(new URL("http://localhost:8080/zanata/"));
    }

    @Test
    public void testValidEnabledOptions() throws Exception {
        this.opts.setUserEnabled("true");
        MatcherAssert.assertThat((Object)this.opts.isUserEnabled(), (Matcher)Matchers.equalTo((Object)"true"));
        this.opts.setUserEnabled("false");
        MatcherAssert.assertThat((Object)this.opts.isUserEnabled(), (Matcher)Matchers.equalTo((Object)"false"));
        this.opts.setUserEnabled("auto");
        MatcherAssert.assertThat((Object)this.opts.isUserEnabled(), (Matcher)Matchers.equalTo((Object)"auto"));
        this.expectException.expect(RuntimeException.class);
        this.expectException.expectMessage("--user-enabled requires true or false (or auto)");
        this.opts.setUserEnabled("invalid");
    }

    @Test
    public void testUserKeyCannotBeBlank() {
        this.opts.setUserKey("   ");
        MatcherAssert.assertThat((Object)this.opts.getUserKey(), (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void testCommandDescription() {
        MatcherAssert.assertThat((Object)this.opts.getCommandName(), (Matcher)Matchers.equalTo((Object)"put-user"));
        MatcherAssert.assertThat((Object)this.opts.getCommandDescription(), (Matcher)Matchers.equalTo((Object)Messages.get((String)"command.description.put-user")));
    }
}

