/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.init.UserConfigHandler;

public class UserConfigHandlerTest {
    @Rule
    public ExpectedException expectException = ExpectedException.none();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private InitOptionsImpl opts;
    private UserConfigHandler handler;
    private File userConfig;

    @Before
    public void setUp() throws IOException {
        this.opts = new InitOptionsImpl();
        this.ensureUserConfigExistsWithOneServer();
        ConsoleInteractor console = (ConsoleInteractor)Mockito.mock(ConsoleInteractor.class);
        this.handler = new UserConfigHandler(console, (InitOptions)this.opts);
    }

    private void ensureUserConfigExistsWithOneServer() throws IOException {
        this.userConfig = this.tempFolder.newFile("zanata.ini");
        BufferedWriter writer = Files.newWriter((File)this.userConfig, (Charset)Charsets.UTF_8);
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("[servers]");
        printWriter.println("a.url=http://localhost:8080/zanata/");
        printWriter.println("a.username=admin");
        printWriter.println("a.key=abcde");
        printWriter.flush();
        printWriter.close();
        this.opts.setUserConfig(this.userConfig);
    }

    @Test
    public void exitWhenThereIsNoUserConfig() throws Exception {
        this.expectException.expect(RuntimeException.class);
        this.expectException.expectMessage(Messages.get((String)"missing.user.config"));
        this.opts.setUserConfig(new File("/planet/Mars/zanata.ini"));
        this.handler.verifyUserConfig();
    }

    @Test
    public void willExitWhenThereIsNoServerUrlInFile() throws Exception {
        this.expectException.expect(RuntimeException.class);
        this.expectException.expectMessage(Messages.get((String)"missing.server.url"));
        BufferedWriter writer = Files.newWriter((File)this.userConfig, (Charset)Charsets.UTF_8);
        writer.write("[servers]");
        writer.close();
        this.handler.verifyUserConfig();
    }

    @Test
    public void willUseUserConfigIfThereIsOnlyOneServer() throws Exception {
        this.handler.verifyUserConfig();
        MatcherAssert.assertThat((Object)this.handler.getOpts().getUrl().toString(), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/zanata/"));
        MatcherAssert.assertThat((Object)this.handler.getOpts().getUsername(), (Matcher)Matchers.equalTo((Object)"admin"));
        MatcherAssert.assertThat((Object)this.handler.getOpts().getKey(), (Matcher)Matchers.equalTo((Object)"abcde"));
    }

    @Test
    public void willAskUserIfUserConfigHasMoreThanOneServerEntries() throws Exception {
        Files.append((CharSequence)"\nb.url=https://translate.zanata.org\n", (File)this.userConfig, (Charset)Charsets.UTF_8);
        Files.append((CharSequence)"b.username=admin\n", (File)this.userConfig, (Charset)Charsets.UTF_8);
        Files.append((CharSequence)"b.key=blah\n", (File)this.userConfig, (Charset)Charsets.UTF_8);
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("2");
        this.handler = new UserConfigHandler(console, (InitOptions)this.opts);
        this.handler.verifyUserConfig();
        MatcherAssert.assertThat((Object)this.handler.getOpts().getUrl().toString(), (Matcher)Matchers.equalTo((Object)"https://translate.zanata.org"));
        MatcherAssert.assertThat((Object)this.handler.getOpts().getUsername(), (Matcher)Matchers.equalTo((Object)"admin"));
        MatcherAssert.assertThat((Object)this.handler.getOpts().getKey(), (Matcher)Matchers.equalTo((Object)"blah"));
    }
}

