/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.fedorahosted.openprops.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.pull.PropertiesStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.UTF8PropertiesStrategy;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.util.PathUtil;

public class PropertiesPullStrategyTest {
    File outDir = new File("target/test-output/writeprops/");
    Properties props = new Properties();
    @Mock
    private PullOptions opts;
    private Resource doc;

    @Before
    public void prepare() throws IOException {
        PathUtil.makeDirs((File)this.outDir);
        this.doc = new Resource(null);
        this.doc.getTextFlows().add(this.newTextFlow("key", "value"));
        this.doc.getTextFlows().add(this.newTextFlow("unicode", "\u30ec\u30b9"));
    }

    @Before
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.opts.getSrcDir()).thenReturn((Object)this.outDir);
    }

    @Test
    public void utf8() throws Exception {
        UTF8PropertiesStrategy strat = new UTF8PropertiesStrategy(this.opts);
        this.doc.setName("utf8");
        strat.writeSrcFile(this.doc);
        File f = new File(this.outDir, "utf8.properties");
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
        this.props.load((Reader)r);
        this.checkResults(this.props);
    }

    @Test
    public void latin1() throws Exception {
        PropertiesStrategy strat = new PropertiesStrategy(this.opts);
        this.doc.setName("latin1");
        strat.writeSrcFile(this.doc);
        File f = new File(this.outDir, "latin1.properties");
        try (FileInputStream inStream = new FileInputStream(f);){
            this.props.load((InputStream)inStream);
        }
        this.checkResults(this.props);
    }

    private TextFlow newTextFlow(String key, String value) {
        TextFlow tf = new TextFlow();
        tf.setId(key);
        tf.setContents(new String[]{value});
        return tf;
    }

    private void checkResults(Properties props) {
        Assert.assertEquals((Object)props.getProperty("key"), (Object)"value");
        Assert.assertEquals((Object)props.getProperty("unicode"), (Object)"\u30ec\u30b9");
    }
}

