/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.zanata.client.commands.stats.ContainerStatisticsCommandOutput;
import org.zanata.rest.dto.Link;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.TranslationStatistics;

public class ConsoleStatisticsOutput
implements ContainerStatisticsCommandOutput {
    @Override
    public void write(ContainerTranslationStatistics statistics) {
        Link sourceRef;
        ArrayList stats = statistics.getStats();
        if (stats == null) {
            stats = new ArrayList();
        }
        if ((sourceRef = statistics.getRefs().findLinkByRel("statSource")).getType().equals("PROJ_ITER")) {
            System.out.println("Project Version: " + statistics.getId());
        } else if (sourceRef.getType().equals("DOC")) {
            System.out.println();
            System.out.println("Document: " + statistics.getId());
        }
        Collections.sort(stats, new Comparator<TranslationStatistics>(){

            @Override
            public int compare(TranslationStatistics o1, TranslationStatistics o2) {
                int localeComparisson = o1.getLocale().compareTo(o2.getLocale());
                if (localeComparisson == 0) {
                    return o1.getUnit().toString().compareTo(o2.getUnit().toString());
                }
                return localeComparisson;
            }
        });
        String[] headers = new String[]{"Locale", "Unit", "Total", "Translated", "Need Review", "Untranslated", "Last Translated"};
        Object[][] data = new Object[stats.size()][headers.length];
        int i = 0;
        int statsSize = stats.size();
        while (i < statsSize) {
            TranslationStatistics s = (TranslationStatistics)stats.get(i);
            data[i] = new Object[]{s.getLocale(), s.getUnit(), s.getTotal(), s.getTranslatedAndApproved(), s.getDraft(), s.getUntranslated(), s.getLastTranslated()};
            ++i;
        }
        ConsoleStatisticsOutput.printTable(headers, data);
        if (statistics.getDetailedStats() != null) {
            for (ContainerTranslationStatistics detailedStats : statistics.getDetailedStats()) {
                this.write(detailedStats);
            }
        }
    }

    private static void printTable(String[] headers, Object[][] rows) {
        int[] colWidths = new int[headers.length];
        int tableWidth = 0;
        int i = 0;
        while (i < headers.length) {
            int maxWidth = headers[i].length() + 3;
            Object[][] objectArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] row = objectArray[n2];
                if (row[i].toString().length() + 3 > maxWidth) {
                    maxWidth = row[i].toString().length() + 3;
                }
                ++n2;
            }
            colWidths[i] = maxWidth;
            tableWidth += maxWidth;
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < tableWidth) {
            System.out.print("=");
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < headers.length) {
            System.out.printf("%1$" + colWidths[i] + "s", headers[i]);
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < tableWidth) {
            System.out.print("=");
            ++i;
        }
        System.out.println();
        Object[][] objectArray = rows;
        int n = rows.length;
        int n3 = 0;
        while (n3 < n) {
            Object[] row = objectArray[n3];
            int i2 = 0;
            int rowLength = row.length;
            while (i2 < rowLength) {
                Object column = row[i2];
                System.out.printf("%1$" + colWidths[i2] + "s", column);
                ++i2;
            }
            System.out.println();
            ++n3;
        }
        i = 0;
        while (i < tableWidth) {
            System.out.print("=");
            ++i;
        }
        System.out.println();
    }
}

