/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.util;

import java.io.Console;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ConsoleUtils {
    private static final Timer timer = new Timer(true);
    private static final Map<TimerTaskType, TimerTask> activeTasks = new HashMap<TimerTaskType, TimerTask>();

    public static void startProgressFeedback() {
        if (activeTasks.containsKey((Object)TimerTaskType.ProgressFeedback)) {
            activeTasks.get((Object)TimerTaskType.ProgressFeedback).cancel();
            activeTasks.remove((Object)TimerTaskType.ProgressFeedback);
        }
        TimeProgressTask progressFeedbackTask = new TimeProgressTask();
        timer.schedule((TimerTask)progressFeedbackTask, 0L, 1000L);
        activeTasks.put(TimerTaskType.ProgressFeedback, progressFeedbackTask);
    }

    public static void setProgressFeedbackMessage(String mssg) {
        if (activeTasks.containsKey((Object)TimerTaskType.ProgressFeedback)) {
            TimeProgressTask task = (TimeProgressTask)activeTasks.get((Object)TimerTaskType.ProgressFeedback);
            task.setSuffix(mssg);
        }
    }

    public static void endProgressFeedback() {
        TimerTask task = activeTasks.remove((Object)TimerTaskType.ProgressFeedback);
        if (task != null) {
            task.cancel();
        }
    }

    private static void printf(String format, Object ... args) {
        Console console = System.console();
        if (console != null) {
            console.printf(format, args);
        }
    }

    private static String formatDuration(Date start, Date end) {
        long durationInSecs = (end.getTime() - start.getTime()) / 1000L;
        StringBuilder formattedDuration = new StringBuilder();
        long minutes = durationInSecs / 60L;
        if (minutes > 0L) {
            formattedDuration.append(String.valueOf(minutes) + " mins");
        }
        long secs = durationInSecs % 60L;
        if (formattedDuration.length() > 0) {
            formattedDuration.append(":");
        }
        formattedDuration.append(String.valueOf(secs) + " secs");
        return formattedDuration.toString();
    }

    private static class TimeProgressTask
    extends TimerTask {
        private static final String[] SEQUENCE = new String[]{"[==   ]", "[ ==  ]", "[  == ]", "[   ==]", "[  == ]", "[ ==  ]"};
        private String suffix = "";
        private Date start;
        private int currentState = -1;
        private String lastOutput = null;

        private TimeProgressTask() {
        }

        public void setSuffix(String newSuffix) {
            StringBuilder spaces = new StringBuilder();
            if (newSuffix.length() < this.suffix.length()) {
                int i = 0;
                while (i < this.suffix.length() - newSuffix.length()) {
                    spaces.append(" ");
                    ++i;
                }
            }
            this.suffix = String.valueOf(newSuffix) + spaces.toString();
        }

        @Override
        public void run() {
            if (this.start == null) {
                this.start = new Date();
            }
            if (this.currentState < 0 || this.currentState >= SEQUENCE.length) {
                this.currentState = 0;
            }
            String output = String.valueOf(SEQUENCE[this.currentState++]) + this.suffix;
            ConsoleUtils.printf("\r%s", new Object[]{output});
            this.lastOutput = output.trim();
        }

        @Override
        public boolean cancel() {
            if (this.start != null) {
                StringBuilder endMssg = new StringBuilder("Done in " + ConsoleUtils.formatDuration(this.start, new Date()));
                while (this.lastOutput != null && this.lastOutput.length() > endMssg.length()) {
                    endMssg.append(" ");
                }
                ConsoleUtils.printf("\r%s\n", new Object[]{endMssg});
            }
            return super.cancel();
        }
    }

    private static enum TimerTaskType {
        ProgressFeedback;

    }
}

