/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.InputSource;
import org.zanata.adapter.po.PoReader2;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.DocNameWithoutExt;
import org.zanata.client.commands.TransFileResolver;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public abstract class AbstractGettextPushStrategy
extends AbstractPushStrategy {
    private PoReader2 poReader = new PoReader2();
    protected Set<String> localSrcDocNames;

    public AbstractGettextPushStrategy() {
        super(new StringSet("comment;gettext"), ".pot");
    }

    protected void checkSrcFileNames(String projectType, String[] srcFiles, boolean isInteractive) {
    }

    @Override
    public Set<String> findDocNames(File srcDir, ImmutableList<String> includes, ImmutableList<String> excludes, boolean useDefaultExclude, boolean caseSensitive, boolean excludeLocaleFilenames) throws IOException {
        String[] srcFiles;
        if (this.localSrcDocNames != null) {
            return this.localSrcDocNames;
        }
        this.localSrcDocNames = new HashSet<String>();
        String[] stringArray = srcFiles = this.getSrcFiles(srcDir, includes, excludes, false, useDefaultExclude, caseSensitive);
        int n = srcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String potName = stringArray[n2];
            String docName = FilenameUtils.removeExtension((String)potName);
            this.localSrcDocNames.add(docName);
            ++n2;
        }
        this.checkSrcFileNames(this.getOpts().getProjectType(), srcFiles, this.getOpts().isInteractiveMode());
        return this.localSrcDocNames;
    }

    protected Set<String> getSrcDocNames() {
        try {
            return this.findDocNames(this.getOpts().getSrcDir(), this.getOpts().getIncludes(), this.getOpts().getExcludes(), this.getOpts().getDefaultExcludes(), this.getOpts().getCaseSensitive(), this.getOpts().getExcludeLocaleFilenames());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    abstract Collection<LocaleMapping> findLocales(String var1);

    protected File getTransFile(LocaleMapping locale, String docName) {
        File transFile = new TransFileResolver((ConfigurableProjectOptions)this.getOpts()).getTransFile(DocNameWithoutExt.from(docName), locale);
        return transFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws IOException {
        File srcFile = new File(sourceDir, String.valueOf(docName) + this.getFileExtension());
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(srcFile);
            try {
                Resource resource;
                block14: {
                    BufferedInputStream bis = new BufferedInputStream(fileInputStream);
                    try {
                        InputSource potInputSource = new InputSource(bis);
                        potInputSource.setEncoding("utf8");
                        resource = this.getPoReader().extractTemplate(potInputSource, new LocaleId(this.getOpts().getSourceLang()), docName);
                        return resource;
                    }
                    finally {
                        if (bis == null) break block14;
                        bis.close();
                    }
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                return resource;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public void visitTranslationResources(String srcDocName, Resource srcDoc, PushCommand.TranslationResourcesVisitor callback) throws IOException {
        for (LocaleMapping locale : this.findLocales(srcDocName)) {
            File transFile = this.getTransFile(locale, srcDocName);
            if (!transFile.canRead()) continue;
            Throwable throwable = null;
            Object var8_9 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(transFile));){
                InputSource inputSource = new InputSource(bis);
                inputSource.setEncoding("utf8");
                TranslationsResource targetDoc = this.getPoReader().extractTarget(inputSource);
                callback.visit(locale, targetDoc);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected PoReader2 getPoReader() {
        return this.poReader;
    }
}

