/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import java.io.File;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.init.ProjectConfigHandler;

public class ProjectConfigHandlerTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void willBackupExistingProjectConfig() throws Exception {
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("y");
        InitOptionsImpl opts = new InitOptionsImpl();
        ProjectConfigHandler handler = new ProjectConfigHandler(console, (InitOptions)opts);
        File projectConfig = this.tempFolder.newFile("zanata.xml");
        opts.setProjectConfig(projectConfig);
        handler.handleExistingProjectConfig();
        List<String> capturedPrompts = MockConsoleInteractor.getCapturedPrompts(console);
        String lastMessage = capturedPrompts.get(capturedPrompts.size() - 1);
        MatcherAssert.assertThat((Object)lastMessage, (Matcher)Matchers.containsString((String)"Old project config has been renamed to "));
        String backupPath = lastMessage.replace("Old project config has been renamed to ", "");
        MatcherAssert.assertThat((Object)new File(backupPath).exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)opts.getProj(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)opts.getProjectVersion(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)opts.getProjectType(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)opts.getProjectConfig(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)opts.getSrcDir(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)opts.getTransDir(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)opts.getIncludes(), (Matcher)Matchers.emptyIterable());
        MatcherAssert.assertThat((Object)opts.getExcludes(), (Matcher)Matchers.emptyIterable());
    }
}

