/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.gettext;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class PublicanUtil {
    private static final Logger log = LoggerFactory.getLogger(PublicanUtil.class);

    private PublicanUtil() {
    }

    public static File[] findLocaleDirs(File srcDir) {
        File[] localeDirs = srcDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && !f.getName().equals("pot");
            }
        });
        return localeDirs;
    }

    public static List<LocaleMapping> findLocales(File srcDir) {
        File[] localeDirs = PublicanUtil.findLocaleDirs(srcDir);
        ArrayList<LocaleMapping> locales = new ArrayList<LocaleMapping>();
        File[] fileArray = localeDirs;
        int n = localeDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            locales.add(new LocaleMapping(dir.getName()));
            ++n2;
        }
        return locales;
    }

    public static List<LocaleMapping> findLocales(File srcDir, LocaleList locales) {
        ArrayList<LocaleMapping> localeDirs = new ArrayList<LocaleMapping>();
        for (LocaleMapping loc : locales) {
            File localeDir = new File(srcDir, loc.getLocalLocale());
            if (localeDir.isDirectory()) {
                localeDirs.add(loc);
                continue;
            }
            log.warn("configured locale {} not found; directory {} does not exist", (Object)loc.getLocale(), (Object)loc.getLocalLocale());
        }
        return localeDirs;
    }
}

