/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.pull;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.glossary.pull.GlossaryPullOptions;
import org.zanata.rest.client.ClientUtil;
import org.zanata.rest.client.GlossaryClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.util.PathUtil;

public class GlossaryPullCommand
extends ConfigurableCommand<GlossaryPullOptions> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryPullCommand.class);
    private final GlossaryClient client = this.getClientFactory().getGlossaryClient();

    public GlossaryPullCommand(GlossaryPullOptions opts, RestClientFactory clientFactory) {
        super(opts, clientFactory);
    }

    public GlossaryPullCommand(GlossaryPullOptions opts) {
        this(opts, OptionsUtil.createClientFactory(opts));
    }

    @Override
    public void run() throws Exception {
        Response response;
        String qualifiedName;
        ImmutableList<String> transLang;
        String fileType;
        String string = fileType = StringUtils.isEmpty((CharSequence)((GlossaryPullOptions)this.getOpts()).getFileType()) ? "csv" : ((GlossaryPullOptions)this.getOpts()).getFileType();
        if (!fileType.equalsIgnoreCase("po") && !fileType.equalsIgnoreCase("csv")) {
            throw new RuntimeException("Option '--file-type' is not valid. Please use 'csv' or 'po'");
        }
        log.info("Server: {}", (Object)((GlossaryPullOptions)this.getOpts()).getUrl());
        log.info("Username: {}", (Object)((GlossaryPullOptions)this.getOpts()).getUsername());
        log.info("File type: {}", (Object)fileType);
        if (StringUtils.isNotBlank((CharSequence)((GlossaryPullOptions)this.getOpts()).getProject())) {
            log.info("Project: {}", (Object)((GlossaryPullOptions)this.getOpts()).getProject());
        }
        if ((transLang = ((GlossaryPullOptions)this.getOpts()).getTransLang()) != null && !transLang.isEmpty()) {
            log.info("Translation language: {}", (Object)Joiner.on((String)",").join(transLang));
        }
        String project = ((GlossaryPullOptions)this.getOpts()).getProject();
        try {
            qualifiedName = StringUtils.isBlank((CharSequence)project) ? this.client.getGlobalQualifiedName() : this.client.getProjectQualifiedName(project);
        }
        catch (ResponseProcessingException rpe) {
            if (rpe.getResponse().getStatus() == 404) {
                log.error("Project {} not found", (Object)project);
                return;
            }
            throw rpe;
        }
        log.info("Pulling glossary from server");
        try {
            response = this.client.downloadFile(fileType, transLang, qualifiedName);
        }
        catch (ResponseProcessingException e) {
            if (e.getResponse().getStatus() == 404) {
                log.info("No glossary file in server");
                return;
            }
            throw e;
        }
        InputStream glossaryFile = (InputStream)response.readEntity(InputStream.class);
        if (glossaryFile == null) {
            log.info("No glossary file in server");
            return;
        }
        String fileName = ClientUtil.getFileNameFromHeader((MultivaluedMap)response.getStringHeaders());
        if (fileName == null) {
            log.error("Null filename response from server: " + response.getStatusInfo());
            return;
        }
        File file = new File(fileName);
        PathUtil.makeDirs((File)file.getParentFile());
        try {
            Throwable throwable = null;
            Object var10_13 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                int read;
                byte[] buffer = new byte[1024];
                while ((read = glossaryFile.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            glossaryFile.close();
        }
        log.info("Glossary pulled to {}", (Object)fileName);
    }
}

