/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.etag;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.zanata.client.etag.ETagCache;
import org.zanata.client.etag.ETagCacheEntry;
import org.zanata.client.etag.ETagCacheReaderWriter;

@RunWith(value=JUnit4.class)
public class ETagCacheTest {
    @Test
    public void readCache() {
        InputStream is = this.getClass().getResourceAsStream("/etagcache/etag-cache.xml");
        ETagCache cache = ETagCacheReaderWriter.readCache((InputStream)is);
        MatcherAssert.assertThat((Object)cache.getCacheEntries().size(), (Matcher)CoreMatchers.is((Object)3));
        int i = 0;
        while (i < cache.getCacheEntries().size()) {
            ETagCacheEntry cacheEntry = (ETagCacheEntry)cache.getCacheEntries().get(i);
            MatcherAssert.assertThat((Object)cacheEntry.getLanguage(), (Matcher)CoreMatchers.is((Object)"en"));
            MatcherAssert.assertThat((Object)cacheEntry.getLocalFileMD5(), (Matcher)CoreMatchers.is((Object)"1234"));
            MatcherAssert.assertThat((Object)cacheEntry.getLocalFileName(), (Matcher)CoreMatchers.is((Object)("xyz_abc_" + (i + 1) + ".properties")));
            MatcherAssert.assertThat((Object)cacheEntry.getLocalFileTime(), (Matcher)CoreMatchers.is((Object)"1234"));
            MatcherAssert.assertThat((Object)cacheEntry.getServerETag(), (Matcher)CoreMatchers.is((Object)"ABCDE"));
            ++i;
        }
    }

    @Test
    public void writeCache() throws Exception {
        File cacheFile = File.createTempFile("etag-cache", "xml");
        cacheFile.deleteOnExit();
        FileOutputStream os = new FileOutputStream(cacheFile);
        ETagCache cache = new ETagCache();
        cache.addEntry(new ETagCacheEntry("myfile.txt", "en-US", "1234.5678", "ABCDEFG", "ABCD1234"));
        ETagCacheReaderWriter.writeCache((ETagCache)cache, (OutputStream)os);
        ETagCache readCache = ETagCacheReaderWriter.readCache((InputStream)new FileInputStream(cacheFile));
        MatcherAssert.assertThat((Object)readCache.getCacheEntries().size(), (Matcher)CoreMatchers.is((Object)cache.getCacheEntries().size()));
        int i = 0;
        while (i < cache.getCacheEntries().size()) {
            ETagCacheEntry cacheEntry = (ETagCacheEntry)cache.getCacheEntries().get(i);
            ETagCacheEntry readEntry = (ETagCacheEntry)readCache.getCacheEntries().get(i);
            MatcherAssert.assertThat((Object)cacheEntry.getLanguage(), (Matcher)CoreMatchers.is((Object)readEntry.getLanguage()));
            MatcherAssert.assertThat((Object)cacheEntry.getLocalFileMD5(), (Matcher)CoreMatchers.is((Object)readEntry.getLocalFileMD5()));
            MatcherAssert.assertThat((Object)cacheEntry.getLocalFileName(), (Matcher)CoreMatchers.is((Object)readEntry.getLocalFileName()));
            MatcherAssert.assertThat((Object)cacheEntry.getLocalFileTime(), (Matcher)CoreMatchers.is((Object)readEntry.getLocalFileTime()));
            MatcherAssert.assertThat((Object)cacheEntry.getServerETag(), (Matcher)CoreMatchers.is((Object)readEntry.getServerETag()));
            ++i;
        }
    }

    @Test
    public void findEntry() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/etagcache/etag-cache.xml");
        ETagCache cache = ETagCacheReaderWriter.readCache((InputStream)is);
        MatcherAssert.assertThat((Object)cache.getCacheEntries().size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)cache.findEntry("xyz_abc_1.properties", "en"), (Matcher)CoreMatchers.notNullValue());
    }
}

