/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.DocNameWithExt;
import org.zanata.client.commands.DocNameWithoutExt;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.StringUtil;
import org.zanata.client.commands.TransFileResolver;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.ProjectType;

class TransConfigPrompt {
    private final ConsoleInteractor console;
    private final ConfigurableProjectOptions opts;
    private final Set<String> srcFilesSample;
    private final PullOptionsImpl pullOptions;
    private final TransFilePathFinder transFilePathFinder;
    private int remainingFileNumber;

    public TransConfigPrompt(ConsoleInteractor console, ConfigurableProjectOptions opts, Set<String> srcFiles) {
        this.console = console;
        this.opts = opts;
        this.srcFilesSample = ImmutableSet.copyOf((Iterable)Iterables.limit(srcFiles, (int)5));
        this.remainingFileNumber = srcFiles.size() - this.srcFilesSample.size();
        this.pullOptions = new PullOptionsImpl();
        this.pullOptions.setUrl(opts.getUrl());
        this.pullOptions.setUsername(opts.getUsername());
        this.pullOptions.setKey(opts.getKey());
        this.pullOptions.setProj(opts.getProj());
        this.pullOptions.setProjectVersion(opts.getProjectVersion());
        this.pullOptions.setProjectType(opts.getProjectType());
        this.pullOptions.setLocaleMapList(opts.getLocaleMapList());
        this.transFilePathFinder = this.makeTransFilePathFinder(this.pullOptions);
    }

    TransConfigPrompt promptUser() throws Exception {
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("trans.dir.prompt"), new Object[0]);
        String localTransDir = this.console.expectAnyNotBlankAnswer();
        File transDir = new File(localTransDir);
        this.pullOptions.setTransDir(transDir);
        LocaleList localeMapList = this.pullOptions.getLocaleMapList();
        LocaleMapping localeMapping = TransConfigPrompt.getSampleLocaleMapping(localeMapList);
        Iterable transFiles = Iterables.transform(this.srcFilesSample, (Function)new ToTransFileNameFunction(this.transFilePathFinder, localeMapping));
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("trans.doc.preview"), localeMapping.getLocale());
        for (String transFile : transFiles) {
            this.console.printfln("%s%s", StringUtil.indent(8), transFile);
        }
        if (this.remainingFileNumber > 0) {
            this.console.printfln(Messages.get("remaining.files"), this.remainingFileNumber);
        }
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("trans.dir.confirm.yes.no"), new Object[0]);
        String answer = this.console.expectAnswerWithRetry(ConsoleInteractor.AnswerValidator.YES_NO);
        if (answer.toLowerCase().startsWith("n")) {
            return new TransConfigPrompt(this.console, this.opts, this.srcFilesSample).promptUser();
        }
        this.opts.setTransDir(transDir);
        this.console.blankLine();
        return this;
    }

    private TransFilePathFinder makeTransFilePathFinder(PullOptions opts) {
        if (ProjectType.File.name().equalsIgnoreCase(opts.getProjectType())) {
            return new RawTransFilePathFinder(opts);
        }
        return new OtherTransFilePathFinder(opts);
    }

    private static LocaleMapping getSampleLocaleMapping(LocaleList localeMapList) {
        LocaleMapping localeMapping = localeMapList == null || localeMapList.isEmpty() ? new LocaleMapping("zh") : localeMapList.get(0);
        return localeMapping;
    }

    static class OtherTransFilePathFinder
    implements TransFilePathFinder {
        private final TransFileResolver transFileResolver;

        OtherTransFilePathFinder(PullOptions opts) {
            this.transFileResolver = new TransFileResolver(opts);
        }

        @Override
        public String getTransFileToWrite(String srcDoc, LocaleMapping localeMapping) {
            File transFile = this.transFileResolver.getTransFile(DocNameWithoutExt.from(srcDoc), localeMapping);
            return transFile.getPath();
        }
    }

    static class RawTransFilePathFinder
    implements TransFilePathFinder {
        private final TransFileResolver transFileResolver;

        RawTransFilePathFinder(PullOptions opts) {
            this.transFileResolver = new TransFileResolver(opts);
        }

        @Override
        public String getTransFileToWrite(String srcDoc, LocaleMapping localeMapping) {
            String targetFileExt = FilenameUtils.getExtension((String)srcDoc);
            Optional translationFileExtension = Optional.fromNullable((Object)targetFileExt);
            File file = this.transFileResolver.resolveTransFile(DocNameWithExt.from(srcDoc), localeMapping, (Optional<String>)translationFileExtension);
            return file.getPath();
        }
    }

    private static class ToTransFileNameFunction
    implements Function<String, String> {
        private final TransFilePathFinder transFilePathFinder;
        private final LocaleMapping localeMapping;

        public ToTransFileNameFunction(TransFilePathFinder transFilePathFinder, LocaleMapping localeMapping) {
            this.transFilePathFinder = transFilePathFinder;
            this.localeMapping = localeMapping;
        }

        public String apply(String input) {
            return this.transFilePathFinder.getTransFileToWrite(input, this.localeMapping);
        }
    }

    static interface TransFilePathFinder {
        public String getTransFileToWrite(String var1, LocaleMapping var2);
    }
}

