/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.DocNameWithoutExt;
import org.zanata.client.commands.TransFileResolver;
import org.zanata.client.commands.push.AbstractGettextPushStrategy;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class GettextPushStrategy
extends AbstractGettextPushStrategy {
    private static final Logger log = LoggerFactory.getLogger(GettextPushStrategy.class);

    List<LocaleMapping> findLocales(String srcDocName) {
        Collection transFilesOnDisk = FileUtils.listFiles((File)this.getOpts().getTransDir(), (String[])new String[]{"po"}, (boolean)true);
        LocaleList localeListInConfig = this.getOpts().getLocaleMapList();
        if (localeListInConfig == null || localeListInConfig.isEmpty()) {
            log.warn("No locale list in configuration (check your server settings)");
            return Collections.emptyList();
        }
        DocNameWithoutExt docNameWithoutExt = DocNameWithoutExt.from(srcDocName);
        List transFilesDestinations = Lists.transform((List)localeListInConfig, (Function)new LocaleMappingToTransFile(docNameWithoutExt, (PushOptions)this.getOpts()));
        transFilesOnDisk.removeAll(transFilesDestinations);
        for (File transFile : transFilesOnDisk) {
            log.warn("Skipping file {}; no locale entry found from project config", (Object)transFile);
        }
        return localeListInConfig;
    }

    private static class LocaleMappingToTransFile
    implements Function<LocaleMapping, File> {
        private final DocNameWithoutExt docNameWithoutExt;
        private TransFileResolver transFileResolver;

        public LocaleMappingToTransFile(DocNameWithoutExt docNameWithoutExt, PushOptions opts) {
            this.docNameWithoutExt = docNameWithoutExt;
            this.transFileResolver = new TransFileResolver(opts);
        }

        public File apply(LocaleMapping localeMapping) {
            return this.transFileResolver.getTransFile(this.docNameWithoutExt, localeMapping);
        }
    }
}

