/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.base.Optional;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.DocNameWithExt;
import org.zanata.client.commands.FileMappingRuleHandler;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;

public class FileMappingRuleHandlerTest {
    private ConfigurableProjectOptions opts = new PushOptionsImpl();

    @Test
    public void canCheckSyntaxErrorInTheRule() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)FileMappingRuleHandler.isRuleValid((String)"{a")).as("unbalanced brace", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)FileMappingRuleHandler.isRuleValid((String)"a}")).as("unbalanced brace", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)FileMappingRuleHandler.isRuleValid((String)"a")).as("missing brace", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)FileMappingRuleHandler.isRuleValid((String)"{a}")).as("invalid placeholder", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)FileMappingRuleHandler.isRuleValid((String)"{path}")).as("missing mandatory placeholder", new Object[0])).isFalse();
        Assertions.assertThat((boolean)FileMappingRuleHandler.isRuleValid((String)"{path}/{locale_with_underscore}.po")).isTrue();
        Assertions.assertThat((boolean)FileMappingRuleHandler.isRuleValid((String)"{path}/../{locale}/{filename}.po")).isTrue();
    }

    @Test
    public void willReturnTransFileRelativePath() {
        Assertions.assertThat((String)this.getTransFile("pot/message.pot", "fr", "{path}/../{locale}/{filename}.po")).isEqualTo((Object)"fr/message.po");
        Assertions.assertThat((String)this.getTransFile("./message.pot", "fr", "{path}/{locale_with_underscore}.po")).isEqualTo((Object)"fr.po");
        Assertions.assertThat((String)this.getTransFile("a/path/message.odt", "de-DE", "{path}/{locale_with_underscore}_{filename}.{extension}")).isEqualTo((Object)"a/path/de_DE_message.odt");
    }

    @Test
    public void ifNoPatternWillUseProjectType() {
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule(null, "{path}/{locale_with_underscore}.po"), this.opts);
        Assertions.assertThat((String)handler.getRelativeTransFilePathForSourceDoc(DocNameWithExt.from((String)"message.pot"), new LocaleMapping("zh"), Optional.absent())).isEqualTo((Object)"zh.po");
    }

    private String getTransFile(String sourceFile, String locale, String rule) {
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule("**/*", rule), this.opts);
        return handler.getRelativeTransFilePathForSourceDoc(DocNameWithExt.from((String)sourceFile), new LocaleMapping(locale), Optional.absent());
    }

    @Test
    public void canGetPartsFromFullFilename() {
        EnumMap map = FileMappingRuleHandler.parseToMap((String)"foo/message.pot", (LocaleMapping)new LocaleMapping("zh-CN", "zh-Hans"), (Optional)Optional.absent());
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.path, (Object)"foo");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.filename, (Object)"message");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.extension, (Object)"pot");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.locale, (Object)"zh-Hans");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.localeWithUnderscore, (Object)"zh_Hans");
    }

    @Test
    public void canGetPartsFromFullFilename2() {
        EnumMap map = FileMappingRuleHandler.parseToMap((String)"foo/message.pot", (LocaleMapping)new LocaleMapping("zh-CN", "zh-Hans"), (Optional)Optional.of((Object)"po"));
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.path, (Object)"foo");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.filename, (Object)"message");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.extension, (Object)"po");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.locale, (Object)"zh-Hans");
        Assertions.assertThat((Map)map).containsEntry((Object)FileMappingRuleHandler.Placeholders.localeWithUnderscore, (Object)"zh_Hans");
    }

    @Test
    public void canTestApplicable() {
        this.opts.setSrcDir(new File("."));
        FileMappingRuleHandler handler = new FileMappingRuleHandler(new FileMappingRule("**/*.odt", "{locale}/{filename}.{extension}"), this.opts);
        Assertions.assertThat((boolean)handler.isApplicable(DocNameWithExt.from((String)"test/doc.odt"))).isTrue();
        Assertions.assertThat((boolean)handler.isApplicable(DocNameWithExt.from((String)"test/doc.pot"))).isFalse();
        Assertions.assertThat((boolean)handler.isApplicable(DocNameWithExt.from((String)"doc.pot"))).isFalse();
        Assertions.assertThat((boolean)handler.isApplicable(DocNameWithExt.from((String)"doc.odt"))).isTrue();
    }
}

