/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.init.ProjectConfigHandler;

public class ProjectConfigHandlerTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void willBackupExistingProjectConfig() throws Exception {
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("y");
        InitOptionsImpl opts = new InitOptionsImpl();
        ProjectConfigHandler handler = new ProjectConfigHandler(console, (InitOptions)opts);
        File projectConfig = this.tempFolder.newFile("zanata.xml");
        opts.setProjectConfig(projectConfig);
        handler.handleExistingProjectConfig();
        List<String> capturedPrompts = MockConsoleInteractor.getCapturedPrompts(console);
        String lastMessage = capturedPrompts.get(capturedPrompts.size() - 1);
        Assertions.assertThat((String)lastMessage).contains(new CharSequence[]{"Old project config has been renamed to "});
        String backupPath = lastMessage.replace("Old project config has been renamed to ", "");
        Assertions.assertThat((boolean)new File(backupPath).exists()).isTrue();
        Assertions.assertThat((String)opts.getProj()).isNull();
        Assertions.assertThat((String)opts.getProjectVersion()).isNull();
        Assertions.assertThat((String)opts.getProjectType()).isNull();
        Assertions.assertThat((File)opts.getProjectConfig()).isNull();
        Assertions.assertThat((File)opts.getSrcDir()).isNull();
        Assertions.assertThat((File)opts.getTransDir()).isNull();
        Assertions.assertThat((List)opts.getIncludes()).isEmpty();
        Assertions.assertThat((List)opts.getExcludes()).isEmpty();
    }
}

