/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.zanata.client.TempTransFileRule;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.commands.push.XmlStrategy;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class XmlStrategyTest {
    @Rule
    public TempTransFileRule tempFileRule = new TempTransFileRule();
    private XmlStrategy strategy;
    private PushOptionsImpl opts;
    @Captor
    private ArgumentCaptor<TranslationsResource> transResourceCaptor;
    @Mock
    private PushCommand.TranslationResourcesVisitor visitor;
    private Resource sourceResource;
    @Captor
    private ArgumentCaptor<File> fileCapture;
    @Mock
    private Unmarshaller unmarshaller;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.strategy = new XmlStrategy(this.unmarshaller);
        this.opts = new PushOptionsImpl();
        this.opts.setLocaleMapList(new LocaleList());
        this.opts.setTransDir(this.tempFileRule.getTransDir());
        this.opts.setProjectType("xml");
        this.strategy.setPushOptions((PushOptions)this.opts);
        this.sourceResource = new Resource("test");
    }

    @Test
    public void canVisitTranslationFileWithoutFileMapping() throws Exception {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.getLocaleMapList().add(new LocaleMapping("ja"));
        File deTransFile = this.tempFileRule.createTransFileRelativeToTransDir("foo/message_de.xml");
        File zhTransFile = this.tempFileRule.createTransFileRelativeToTransDir("foo/message_zh_Hans.xml");
        this.strategy.visitTranslationResources("foo/message", this.sourceResource, this.visitor);
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)Matchers.eq((Object)deMapping), (TranslationsResource)this.transResourceCaptor.capture());
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)Matchers.eq((Object)zhMapping), (TranslationsResource)this.transResourceCaptor.capture());
        ((Unmarshaller)Mockito.verify((Object)this.unmarshaller, (VerificationMode)Mockito.times((int)2))).unmarshal((File)this.fileCapture.capture());
        Assertions.assertThat((List)this.fileCapture.getAllValues()).contains((Object[])new File[]{deTransFile, zhTransFile});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }

    @Test
    public void canVisitTranslationFileUsingFileMapping() throws Exception {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.getLocaleMapList().add(new LocaleMapping("ja"));
        File deTransFile = this.tempFileRule.createTransFileRelativeToTransDir("foo/message_de.xml");
        File zhTransFile = this.tempFileRule.createTransFileRelativeToTransDir("foo/message_zh_Hans.xml");
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("{path}/{filename}_{locale_with_underscore}.{extension}")}));
        this.strategy.visitTranslationResources("foo/message", this.sourceResource, this.visitor);
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)Matchers.eq((Object)deMapping), (TranslationsResource)this.transResourceCaptor.capture());
        ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)this.visitor)).visit((LocaleMapping)Matchers.eq((Object)zhMapping), (TranslationsResource)this.transResourceCaptor.capture());
        ((Unmarshaller)Mockito.verify((Object)this.unmarshaller, (VerificationMode)Mockito.times((int)2))).unmarshal((File)this.fileCapture.capture());
        Assertions.assertThat((List)this.fileCapture.getAllValues()).contains((Object[])new File[]{deTransFile, zhTransFile});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }
}

