/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.ConsoleInteractorImpl;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.StringUtil;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.client.commands.push.RawPushStrategy;
import org.zanata.common.FileTypeInfo;
import org.zanata.common.ProjectType;
import org.zanata.rest.client.FileResourceClient;
import org.zanata.rest.client.RestClientFactory;

class SourceConfigPrompt {
    private static final Logger log = LoggerFactory.getLogger(SourceConfigPrompt.class);
    private final ConsoleInteractor console;
    private final ConfigurableProjectOptions opts;
    private final PushOptions pushOptions;
    private final SrcDocsFinder srcDocsFinder;
    private String includes;
    private String excludes;
    private Set<String> docNames;

    public SourceConfigPrompt(ConsoleInteractor console, ConfigurableProjectOptions opts) throws InvocationTargetException, IllegalAccessException {
        this.console = console;
        this.opts = opts;
        this.pushOptions = new PushOptionsImpl();
        this.pushOptions.setProj(opts.getProj());
        this.pushOptions.setProjectVersion(opts.getProjectVersion());
        this.pushOptions.setProjectType(opts.getProjectType());
        this.pushOptions.setUrl(opts.getUrl());
        this.pushOptions.setUsername(opts.getUsername());
        this.pushOptions.setKey(opts.getKey());
        this.pushOptions.setLocaleMapList(opts.getLocaleMapList());
        this.srcDocsFinder = this.makeSrcDocFinder();
    }

    SourceConfigPrompt promptUser() throws Exception {
        Object answer;
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("src.dir.prompt"), new Object[0]);
        String localSrcDir = this.console.expectAnyNotBlankAnswer();
        File srcDir = new File(localSrcDir);
        if (!srcDir.exists()) {
            this.console.printfln(ConsoleInteractor.DisplayMode.Warning, Messages.get("src.dir.not.exist"), localSrcDir);
            return new SourceConfigPrompt(this.console, this.opts).promptUser();
        }
        this.console.blankLine();
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("includes.question"), new Object[0]);
        this.console.printfln(Messages.get("includes.usage.1"), new Object[0]);
        this.console.printfln(Messages.get("includes.usage.2"), new Object[0]);
        this.console.printfln(Messages.get("includes.usage.3"), new Object[0]);
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("includes.prompt"), new Object[0]);
        this.includes = this.console.expectAnyAnswer();
        this.console.blankLine();
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("excludes.question"), new Object[0]);
        this.console.printfln(Messages.get("excludes.usage"), new Object[0]);
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("excludes.prompt"), new Object[0]);
        this.excludes = this.console.expectAnyAnswer();
        this.pushOptions.setSrcDir(srcDir);
        this.pushOptions.setIncludes(this.includes);
        this.pushOptions.setExcludes(this.excludes);
        if (ProjectType.File.name().equalsIgnoreCase(this.pushOptions.getProjectType())) {
            this.console.blankLine();
            this.console.printfln(ConsoleInteractor.DisplayMode.Question, Messages.get("project.file.type.question"), new Object[0]);
            this.console.printfln(ConsoleInteractor.DisplayMode.Hint, "File types to locate and transmit to the server\nwhen using project type \"file\".\nNOTE: No file types will be pushed unless listed here.\nPattern: TYPE[extension;extension],TYPE[extension]\nThe default file extension(s) for each TYPE will be used unless\n'extension' is specified in square brackets. If overriding extensions,\nplease note that most shells require quotes around square brackets and \nsemicolons unless they are escaped.\nExample: --file-types \"PROPERTIES,PLAIN_TEXT[md;txt]\"\nUse push with the option --list-file-types to see the server's\nsupported types and their default extensions.", new Object[0]);
            this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("file.type.prompt"), new Object[0]);
            answer = this.console.expectAnyNotBlankAnswer();
            ((PushOptionsImpl)this.pushOptions).setFileTypes((String)answer);
        }
        this.console.blankLine();
        this.docNames = this.findDocNames();
        if (this.docNames.isEmpty()) {
            this.console.printfln(Messages.get("no.source.doc.found"), new Object[0]);
        } else {
            this.console.printfln(Messages.get("found.source.docs"), new Object[0]);
            for (String docName : this.docNames) {
                this.console.printfln("%s%s", StringUtil.indent(8), docName);
            }
        }
        this.console.printf(ConsoleInteractor.DisplayMode.Question, Messages.get("source.doc.confirm.yes.no"), new Object[0]);
        answer = this.console.expectAnswerWithRetry(ConsoleInteractorImpl.AnswerValidatorImpl.YES_NO);
        if (((String)answer).toLowerCase().startsWith("n")) {
            this.hintAdvancedConfigurations();
            return new SourceConfigPrompt(this.console, this.opts).promptUser();
        }
        this.opts.setSrcDir(srcDir);
        this.opts.setIncludes(this.includes);
        this.opts.setExcludes(this.excludes);
        this.console.blankLine();
        return this;
    }

    @VisibleForTesting
    protected RestClientFactory getClientFactory(PushOptions pushOptions) {
        return OptionsUtil.createClientFactoryWithoutVersionCheck(pushOptions);
    }

    private Set<String> findDocNames() throws IOException {
        return this.srcDocsFinder.findSrcDocNames();
    }

    private void hintAdvancedConfigurations() {
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, Messages.get("more.src.options.hint"), new Object[0]);
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, " - %s", SourceConfigPrompt.getUsageFromOptionAnnotation(PushOptionsImpl.class, "setDefaultExcludes", Boolean.TYPE));
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, " - %s", SourceConfigPrompt.getUsageFromOptionAnnotation(PushOptionsImpl.class, "setCaseSensitive", Boolean.TYPE));
        this.console.printfln(ConsoleInteractor.DisplayMode.Hint, " - %s", SourceConfigPrompt.getUsageFromOptionAnnotation(PushOptionsImpl.class, "setExcludeLocaleFilenames", Boolean.TYPE));
    }

    private static <T> String getUsageFromOptionAnnotation(Class<? extends BasicOptions> optionsClass, String methodName, Class<T> argType) {
        try {
            return optionsClass.getMethod(methodName, argType).getAnnotation(Option.class).usage().replaceAll(System.getProperty("line.separator"), " ");
        }
        catch (NoSuchMethodException e) {
            log.error("can not find method: {} on class {}", (Object)methodName, optionsClass);
            return methodName;
        }
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public Set<String> getDocNames() {
        return this.docNames;
    }

    private SrcDocsFinder makeSrcDocFinder() {
        String projectType = this.pushOptions.getProjectType();
        if (projectType.equalsIgnoreCase(ProjectType.File.name())) {
            return new RawSrcDocsFinder(this.pushOptions);
        }
        return new OtherSrcDocsFinder(this.pushOptions);
    }

    class OtherSrcDocsFinder
    implements SrcDocsFinder {
        private final AbstractPushStrategy strategy;
        private PushOptions opts;

        OtherSrcDocsFinder(PushOptions pushOptions) {
            this.opts = pushOptions;
            RestClientFactory clientFactory = SourceConfigPrompt.this.getClientFactory(pushOptions);
            PushCommand pushCommand = new PushCommand(pushOptions, clientFactory.getCopyTransClient(), clientFactory.getAsyncProcessClient(), clientFactory);
            this.strategy = pushCommand.getStrategy(pushOptions);
        }

        @Override
        public Set<String> findSrcDocNames() {
            try {
                return this.strategy.findDocNames(this.opts.getSrcDir(), this.opts.getIncludes(), this.opts.getExcludes(), this.opts.getDefaultExcludes(), this.opts.getCaseSensitive(), this.opts.getExcludeLocaleFilenames());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class RawSrcDocsFinder
    implements SrcDocsFinder {
        private final RawPushStrategy strategy = new RawPushStrategy();

        RawSrcDocsFinder(PushOptions pushOptions) {
            this.strategy.setPushOptions(pushOptions);
        }

        @Override
        public Set<String> findSrcDocNames() {
            Object opts = this.strategy.getOpts();
            ImmutableList<String> extensions = this.filteredFileExtensions((PushOptions)opts);
            return ImmutableSet.copyOf((Object[])this.strategy.getSrcFiles(opts.getSrcDir(), opts.getIncludes(), opts.getExcludes(), extensions, opts.getDefaultExcludes(), opts.getCaseSensitive()));
        }

        private ImmutableList<String> filteredFileExtensions(PushOptions opts) {
            FileResourceClient client;
            List<FileTypeInfo> serverFileTypes;
            RestClientFactory clientFactory = SourceConfigPrompt.this.getClientFactory(opts);
            RawPushCommand rawPushCommand = new RawPushCommand(opts, clientFactory, SourceConfigPrompt.this.console);
            ImmutableList<FileTypeInfo> filteredDocTypes = rawPushCommand.getActualFileTypes(serverFileTypes = rawPushCommand.fileTypeInfoList(client = clientFactory.getFileResourceClient()), (List<String>)opts.getFileTypes());
            if (filteredDocTypes.isEmpty()) {
                log.info("no valid types specified; nothing to do");
                return ImmutableList.of();
            }
            ImmutableList.Builder sourceFileExtensions = ImmutableList.builder();
            filteredDocTypes.forEach(type -> sourceFileExtensions.addAll((Iterable)type.getSourceExtensions()));
            return sourceFileExtensions.build();
        }
    }

    static interface SrcDocsFinder {
        public Set<String> findSrcDocNames();
    }
}

