/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.RawPullStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.ClientUtil;
import org.zanata.rest.client.FileResourceClient;
import org.zanata.rest.client.RestClientFactory;

public class RawPullCommand
extends PushPullCommand<PullOptions> {
    private static final Logger log = LoggerFactory.getLogger(RawPullCommand.class);
    private FileResourceClient fileResourceClient;

    public RawPullCommand(PullOptions opts) {
        super(opts);
        this.fileResourceClient = this.getClientFactory().getFileResourceClient();
    }

    @VisibleForTesting
    public RawPullCommand(PullOptions opts, FileResourceClient fileResourceClient, RestClientFactory clientFactory) {
        super(opts, clientFactory);
        this.fileResourceClient = fileResourceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void run() throws IOException {
        boolean pullTarget;
        PullCommand.logOptions(log, (PullOptions)this.getOpts());
        if (((PullOptions)this.getOpts()).isDryRun()) {
            log.info("DRY RUN: no permanent changes will be made");
        }
        log.warn("Using EXPERIMENTAL project type 'file'.");
        LocaleList locales = ((PullOptions)this.getOpts()).getLocaleMapList();
        if (locales == null) {
            throw new ConfigException("no locales specified");
        }
        RawPullStrategy strat = new RawPullStrategy();
        strat.setPullOptions((PullOptions)this.getOpts());
        List<String> docNamesForModule = this.getQualifiedDocNamesForCurrentModuleFromServer();
        TreeSet<String> localDocNames = new TreeSet<String>(docNamesForModule);
        SortedSet<String> docsToPull = localDocNames;
        if (((PullOptions)this.getOpts()).getFromDoc() != null) {
            if (!localDocNames.contains(((PullOptions)this.getOpts()).getFromDoc())) {
                log.error("Document with id {} not found, unable to start pull from unknown document. Aborting.", (Object)((PullOptions)this.getOpts()).getFromDoc());
                return;
            }
            docsToPull = localDocNames.tailSet(((PullOptions)this.getOpts()).getFromDoc());
            int numSkippedDocs = localDocNames.size() - docsToPull.size();
            log.info("Skipping {} document(s) before {}.", (Object)numSkippedDocs, (Object)((PullOptions)this.getOpts()).getFromDoc());
        }
        if (docsToPull.isEmpty()) {
            log.info("No documents in remote module: {}; nothing to do", (Object)((PullOptions)this.getOpts()).getCurrentModule());
            return;
        }
        log.info("Source documents on server:");
        for (String docName : localDocNames) {
            if (docsToPull.contains(docName)) {
                log.info("           {}", (Object)docName);
                continue;
            }
            log.info("(to skip)  {}", (Object)docName);
        }
        log.info("Pulling {} of {} docs for this module from the server", (Object)docsToPull.size(), (Object)localDocNames.size());
        log.debug("Doc names: {}", localDocNames);
        PushPullType pullType = ((PullOptions)this.getOpts()).getPullType();
        boolean pullSrc = pullType == PushPullType.Both || pullType == PushPullType.Source;
        boolean bl = pullTarget = pullType == PushPullType.Both || pullType == PushPullType.Trans;
        if (this.needToGetStatistics(pullTarget)) {
            log.info("Setting minimum document completion percentage may potentially increase the processing time.");
        }
        if (pullSrc) {
            log.warn("Pull Type set to '{}': existing source-language files may be overwritten/deleted", (Object)pullType);
            this.confirmWithUser("This will overwrite/delete any existing documents and translations in the above directories.\n");
        } else {
            this.confirmWithUser("This will overwrite/delete any existing translations in the above directory.\n");
        }
        Optional<Map<String, Map<LocaleId, PushPullCommand.TranslatedPercent>>> optionalStats = this.prepareStatsIfApplicable(pullTarget, locales);
        for (String qualifiedDocName : docsToPull) {
            try {
                String localDocName;
                block22: {
                    localDocName = this.unqualifiedDocName(qualifiedDocName);
                    if (pullSrc) {
                        try {
                            Response response = this.fileResourceClient.downloadSourceFile(((PullOptions)this.getOpts()).getProj(), ((PullOptions)this.getOpts()).getProjectVersion(), "raw", qualifiedDocName);
                            InputStream srcDoc = (InputStream)response.readEntity(InputStream.class);
                            if (srcDoc == null) break block22;
                            try {
                                strat.writeSrcFile(localDocName, srcDoc);
                            }
                            finally {
                                srcDoc.close();
                            }
                        }
                        catch (ResponseProcessingException e) {
                            if (e.getResponse().getStatus() == 404) {
                                log.warn("No source document file is available for [{}]. Skipping.", (Object)qualifiedDocName);
                            }
                            throw e;
                        }
                    }
                }
                if (!pullTarget) continue;
                String fileExtension = ((PullOptions)this.getOpts()).getIncludeFuzzy() ? "half-baked" : "baked";
                ArrayList skippedLocales = Lists.newArrayList();
                for (LocaleMapping locMapping : locales) {
                    LocaleId locale = new LocaleId(locMapping.getLocale());
                    if (this.shouldPullThisLocale(optionalStats, localDocName, locale)) {
                        this.pullDocForLocale(strat, qualifiedDocName, localDocName, fileExtension, locMapping, locale);
                        continue;
                    }
                    skippedLocales.add(locale);
                }
                if (skippedLocales.isEmpty()) continue;
                log.info("Translation file for document {} for locales {} are skipped due to insufficient completed percentage", (Object)localDocName, (Object)skippedLocales);
            }
            catch (IOException | RuntimeException e) {
                log.error("Operation failed: {}\n\n    To retry from the last document, please add the option: {}\n", (Object)e.toString(), (Object)((PullOptions)this.getOpts()).buildFromDocArgument(qualifiedDocName));
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullDocForLocale(RawPullStrategy strat, String qualifiedDocName, String localDocName, String fileExtension, LocaleMapping locMapping, LocaleId locale) throws IOException {
        block10: {
            try (Response response = null;){
                response = this.fileResourceClient.downloadTranslationFile(((PullOptions)this.getOpts()).getProj(), ((PullOptions)this.getOpts()).getProjectVersion(), locale.getId(), fileExtension, qualifiedDocName);
                InputStream transDoc = (InputStream)response.readEntity(InputStream.class);
                if (transDoc == null) break block10;
                try {
                    String fileName = ClientUtil.getFileNameFromHeader((MultivaluedMap)response.getStringHeaders());
                    String targetFileExt = FilenameUtils.getExtension((String)fileName);
                    Optional translationFileExtension = Optional.fromNullable((Object)targetFileExt);
                    strat.writeTransFile(localDocName, locMapping, transDoc, (Optional<String>)translationFileExtension);
                }
                finally {
                    transDoc.close();
                }
            }
        }
    }
}

