/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.assertj.core.api.Assertions;
import org.junit.rules.TemporaryFolder;

public class TempTransFileRule
extends TemporaryFolder {
    private File transDir;

    protected void before() throws Throwable {
        super.before();
        if (this.transDir == null) {
            this.transDir = this.getRoot();
        }
    }

    public File createTransFileRelativeToTransDir(String path) throws IOException {
        File file = new File(this.transDir, path);
        File parentFile = file.getParentFile();
        parentFile.mkdirs();
        Assertions.assertThat((boolean)parentFile.exists()).isTrue();
        Assertions.assertThat((boolean)file.createNewFile()).isTrue();
        return file;
    }

    public void addContentToFile(File file, Charset charset, String content) throws Exception {
        BufferedWriter writer = Files.newWriter((File)file, (Charset)charset);
        writer.write(content);
        writer.close();
    }

    public File getTransDir() {
        return this.transDir;
    }
}

