/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.Messages;
import org.zanata.client.commands.init.InitCommand;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.rest.client.ProjectIterationClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.VersionInfo;

public class InitCommandTest {
    private static final Logger log = LoggerFactory.getLogger(InitCommandTest.class);
    @Rule
    public ExpectedException expectException = ExpectedException.none();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private InitCommand command;
    private InitOptionsImpl opts;
    @Mock
    private ConsoleInteractor console;
    @Mock
    private RestClientFactory clientFactory;
    @Mock
    private ProjectIterationClient projectIterationClient;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new InitOptionsImpl();
        this.command = new InitCommand((InitOptions)this.opts, this.console, this.clientFactory);
    }

    @Test
    public void createCommandWithoutMandatoryOptionsWillNotCauseException() {
        this.command = new InitCommand((InitOptions)this.opts, this.console);
    }

    @Test
    public void willDownloadProjectConfigFromServer() throws IOException {
        Mockito.when((Object)this.clientFactory.getProjectIterationClient("gcc", "master")).thenReturn((Object)this.projectIterationClient);
        Mockito.when((Object)this.projectIterationClient.sampleConfiguration()).thenReturn((Object)TestUtils.readFromClasspath("serverresponse/projectConfig.xml"));
        File configFileDest = new File(this.tempFolder.getRoot(), "zanata.xml");
        this.command.downloadZanataXml("gcc", "master", configFileDest);
        Assertions.assertThat((boolean)configFileDest.exists()).isTrue();
        List lines = FileUtils.readLines((File)configFileDest, (Charset)Charsets.UTF_8);
        String content = Joiner.on((String)"\n").join((Iterable)lines);
        Assertions.assertThat((String)content).contains(new CharSequence[]{"<project>"});
        Assertions.assertThat((File)this.opts.getProjectConfig()).isEqualTo((Object)configFileDest);
    }

    @Test
    public void willWriteSrcDirIncludesExcludesToConfigFile() throws Exception {
        File configFile = new File(this.tempFolder.getRoot(), "zanata.xml");
        configFile.createNewFile();
        FileUtils.write((File)configFile, (CharSequence)TestUtils.readFromClasspath("serverresponse/projectConfig.xml"), (Charset)Charsets.UTF_8);
        this.command.writeToConfig(new File("pot"), null, "", new File("po"), configFile);
        List lines = FileUtils.readLines((File)configFile, (Charset)Charsets.UTF_8);
        StringBuilder content = new StringBuilder();
        for (String line : lines) {
            log.debug(line);
            content.append(line.trim());
        }
        Assertions.assertThat((String)content.toString()).contains(new CharSequence[]{"<src-dir>pot</src-dir><trans-dir>po</trans-dir>"});
    }

    @Test
    public void willQuitIfServerApiVersionDoesNotSupportInit() throws Exception {
        this.expectException.expect(RuntimeException.class);
        this.expectException.expectMessage(Messages.get((String)"server.incompatible"));
        Mockito.when((Object)this.clientFactory.getServerVersionInfo()).thenReturn((Object)new VersionInfo("3.3.1", "unknown", "unknown"));
        this.command = new InitCommand((InitOptions)this.opts, this.console, this.clientFactory);
        this.command.ensureServerVersion();
    }

    @Test
    public void willQuitIfUsernameAndConfigUnavailable() throws Exception {
        this.expectException.expect(RuntimeException.class);
        this.expectException.expectMessage(Messages.get((String)"missing.user.config"));
        this.opts.setUserConfig(new File("/planet/Mars/zanata.ini"));
        this.command.run();
    }
}

