/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.zanata.client.TempTransFileRule;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.push.GettextPushStrategy;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class GettextPushStrategyTest {
    @Rule
    public TempTransFileRule tempFileRule = new TempTransFileRule();
    private GettextPushStrategy strategy;
    private PushOptionsImpl opts;

    @Before
    public void setUp() throws IOException {
        this.strategy = new GettextPushStrategy();
        this.opts = new PushOptionsImpl();
        this.opts.setProjectType("gettext");
        this.opts.setTransDir(this.tempFileRule.getTransDir());
        this.opts.setLocaleMapList(new LocaleList());
        this.strategy.setPushOptions((PushOptions)this.opts);
    }

    @Test
    public void willWorkWithoutMappingRules() throws IOException {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        File deTransFile = this.strategy.getTransFile(deMapping, "po/message");
        Assertions.assertThat((File)deTransFile).isEqualTo((Object)new File(this.tempFileRule.getTransDir(), "po/de.po"));
        File zhTransFile = this.strategy.getTransFile(zhMapping, "po/message");
        Assertions.assertThat((File)zhTransFile).isEqualTo((Object)new File(this.tempFileRule.getTransDir(), "po/zh_Hans.po"));
    }

    @Test
    public void willWorkWithMappingRules() {
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule(null, "{path}/{locale_with_underscore}.po")}));
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        File deTransFile = this.strategy.getTransFile(deMapping, "po/message");
        Assertions.assertThat((File)deTransFile).isEqualTo((Object)new File(this.tempFileRule.getTransDir(), "po/de.po"));
        File zhTransFile = this.strategy.getTransFile(zhMapping, "po/message");
        Assertions.assertThat((File)zhTransFile).isEqualTo((Object)new File(this.tempFileRule.getTransDir(), "po/zh_Hans.po"));
    }
}

