/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.zanata.adapter.properties.PropReader;
import org.zanata.adapter.properties.PropWriter;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.DocNameWithoutExt;
import org.zanata.client.commands.TransFileResolver;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.ContentState;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PropertiesStrategy
extends AbstractPushStrategy {
    private PropReader propReader;
    private final PropWriter.CHARSET charset;

    public PropertiesStrategy() {
        this(PropWriter.CHARSET.Latin1);
    }

    public PropertiesStrategy(PropWriter.CHARSET charset) {
        super(new StringSet("comment"), ".properties");
        this.charset = charset;
    }

    @Override
    public void init() {
        this.propReader = new PropReader(this.charset, new LocaleId(this.getOpts().getSourceLang()), ContentState.Approved);
    }

    @Override
    public Set<String> findDocNames(File srcDir, ImmutableList<String> includes, ImmutableList<String> excludes, boolean useDefaultExclude, boolean caseSensitive, boolean excludeLocaleFilenames) throws IOException {
        String[] files;
        HashSet<String> localDocNames = new HashSet<String>();
        for (String relativeFilePath : files = this.getSrcFiles(srcDir, includes, excludes, excludeLocaleFilenames, useDefaultExclude, caseSensitive)) {
            String baseName = FilenameUtils.removeExtension((String)relativeFilePath);
            localDocNames.add(baseName);
        }
        return localDocNames;
    }

    private Resource loadResource(String docName, File propFile) throws IOException, RuntimeException {
        Resource doc = new Resource(docName);
        try (FileInputStream in = new FileInputStream(propFile);){
            this.propReader.extractTemplate(doc, (InputStream)in);
        }
        return doc;
    }

    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws IOException, RuntimeException {
        String filename = this.docNameToFilename(docName);
        File propFile = new File(sourceDir, filename);
        return this.loadResource(docName, propFile);
    }

    private TranslationsResource loadTranslationsResource(Resource srcDoc, File transFile) throws IOException, RuntimeException {
        TranslationsResource targetDoc = new TranslationsResource();
        try (FileInputStream in = new FileInputStream(transFile);){
            this.propReader.extractTarget(targetDoc, (InputStream)in, srcDoc);
        }
        return targetDoc;
    }

    @Override
    public void visitTranslationResources(String docName, Resource srcDoc, PushCommand.TranslationResourcesVisitor callback) throws IOException, RuntimeException {
        for (LocaleMapping locale : this.getOpts().getLocaleMapList()) {
            File transFile = new TransFileResolver((ConfigurableProjectOptions)this.getOpts()).getTransFile(DocNameWithoutExt.from(docName), locale);
            if (!transFile.exists()) continue;
            TranslationsResource targetDoc = this.loadTranslationsResource(srcDoc, transFile);
            callback.visit(locale, targetDoc);
        }
    }
}

