/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.junit.rules.ExternalResource;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.pull.RawPullCommand;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.commands.push.RawPushCommand;
import org.zanata.client.config.LocaleList;
import org.zanata.common.DocumentType;
import org.zanata.common.LocaleId;
import org.zanata.rest.DocumentFileUploadForm;
import org.zanata.rest.client.AsyncProcessClient;
import org.zanata.rest.client.CopyTransClient;
import org.zanata.rest.client.FileResourceClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.client.SourceDocResourceClient;
import org.zanata.rest.client.TransDocResourceClient;
import org.zanata.rest.dto.ChunkUploadResponse;
import org.zanata.rest.dto.ProcessStatus;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

public class MockServerRule
extends ExternalResource {
    private String mockProcessId = "MockServerRuleProcess";
    private ProcessStatus finished = new ProcessStatus();
    private ProcessStatus running = new ProcessStatus();
    private PullOptionsImpl pullOpts;
    private PushOptionsImpl pushOpts;
    @Captor
    private ArgumentCaptor<Resource> resourceCaptor;
    @Captor
    private ArgumentCaptor<Set<String>> extensionCaptor;
    @Captor
    private ArgumentCaptor<String> docIdCaptor;
    @Captor
    private ArgumentCaptor<LocaleId> localeIdCaptor;
    @Captor
    private ArgumentCaptor<TranslationsResource> transResourceCaptor;
    @Mock
    private Response transResourceResponse;
    @Captor
    private ArgumentCaptor<DocumentFileUploadForm> uploadFormCaptor;
    @Mock
    private Response downloadSourceResponse;
    @Mock
    private Response downloadTransResponse;
    @Mock
    private RestClientFactory clientFactory;
    @Mock
    private CopyTransClient copyTransClient;
    @Mock
    private AsyncProcessClient asyncClient;
    @Mock
    private SourceDocResourceClient sourceDocClient;
    @Mock
    private TransDocResourceClient transDocClient;
    @Mock
    private FileResourceClient fileResourceClient;

    public MockServerRule() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.running.setUrl(this.mockProcessId);
        this.running.setStatusCode(ProcessStatus.ProcessStatusCode.Running);
        this.finished.setUrl(this.mockProcessId);
        this.finished.setStatusCode(ProcessStatus.ProcessStatusCode.Finished);
    }

    protected void before() throws Throwable {
        super.before();
        this.pushOpts = new PushOptionsImpl();
        MockServerRule.setCommonOpts((ConfigurableProjectOptions)this.pushOpts);
        this.pushOpts.setCopyTrans(false);
        this.pullOpts = new PullOptionsImpl();
        MockServerRule.setCommonOpts((ConfigurableProjectOptions)this.pullOpts);
    }

    private static void setCommonOpts(ConfigurableProjectOptions opts) {
        opts.setUsername("admin");
        opts.setKey("abcde");
        opts.setLocaleMapList(new LocaleList());
        opts.setInteractiveMode(false);
        MockServerRule.setUrl(opts);
        opts.setProj("sample-project");
        opts.setProjectVersion("master");
    }

    private static URI setUrl(ConfigurableProjectOptions opts) {
        try {
            URI uri = new URI("http://localhost:8888/zanata");
            opts.setUrl(uri.toURL());
            return uri;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PushCommand createPushCommand() {
        Mockito.when((Object)this.clientFactory.getSourceDocResourceClient(this.pushOpts.getProj(), this.pullOpts.getProjectVersion())).thenReturn((Object)this.sourceDocClient);
        Mockito.when((Object)this.sourceDocClient.getResourceMeta(null)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.asyncClient.startSourceDocCreationOrUpdateWithDocId((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (Resource)Matchers.any(Resource.class), Matchers.anySetOf(String.class), Matchers.anyString())).thenReturn((Object)this.running);
        Mockito.when((Object)this.asyncClient.startTranslatedDocCreationOrUpdateWithDocId((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (LocaleId)this.localeIdCaptor.capture(), (TranslationsResource)this.transResourceCaptor.capture(), (String)this.docIdCaptor.capture(), (Set)this.extensionCaptor.capture(), (String)Matchers.eq((Object)this.pushOpts.getMergeType()), Matchers.eq((boolean)this.pushOpts.isMyTrans()))).thenReturn((Object)this.running);
        Mockito.when((Object)this.asyncClient.getProcessStatus(this.mockProcessId)).thenReturn((Object)this.finished);
        return new PushCommand((PushOptions)this.pushOpts, this.copyTransClient, this.asyncClient, this.clientFactory);
    }

    public PushOptionsImpl getPushOpts() {
        return this.pushOpts;
    }

    public ArgumentCaptor<Resource> getResourceCaptor() {
        return this.resourceCaptor;
    }

    public ArgumentCaptor<Set<String>> getExtensionCaptor() {
        return this.extensionCaptor;
    }

    public ArgumentCaptor<String> getDocIdCaptor() {
        return this.docIdCaptor;
    }

    public ArgumentCaptor<LocaleId> getLocaleIdCaptor() {
        return this.localeIdCaptor;
    }

    public ArgumentCaptor<TranslationsResource> getTransResourceCaptor() {
        return this.transResourceCaptor;
    }

    public void verifyPushSource() {
        ((AsyncProcessClient)Mockito.verify((Object)this.asyncClient)).startSourceDocCreationOrUpdateWithDocId((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (Resource)this.resourceCaptor.capture(), (Set)this.extensionCaptor.capture(), (String)this.docIdCaptor.capture());
    }

    public void verifyPushTranslation() {
        ((AsyncProcessClient)Mockito.verify((Object)this.asyncClient)).startTranslatedDocCreationOrUpdateWithDocId((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (LocaleId)this.localeIdCaptor.capture(), (TranslationsResource)this.transResourceCaptor.capture(), (String)this.docIdCaptor.capture(), (Set)this.extensionCaptor.capture(), (String)Matchers.eq((Object)this.pushOpts.getMergeType()), Matchers.eq((boolean)this.pushOpts.isMyTrans()));
    }

    public PullOptionsImpl getPullOpts() {
        return this.pullOpts;
    }

    public PullCommand createPullCommand(List<ResourceMeta> remoteDocList, Resource resourceOnServer, TranslationsResource transResourceOnServer) {
        Mockito.when((Object)this.clientFactory.getSourceDocResourceClient(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.sourceDocClient);
        Mockito.when((Object)this.sourceDocClient.getResourceMeta(null)).thenReturn(remoteDocList);
        Mockito.when((Object)this.sourceDocClient.getResource(Matchers.anyString(), Matchers.anySetOf(String.class))).thenReturn((Object)resourceOnServer);
        Mockito.when((Object)this.clientFactory.getTransDocResourceClient(this.pullOpts.getProj(), this.pullOpts.getProjectVersion())).thenReturn((Object)this.transDocClient);
        Mockito.when((Object)this.transDocClient.getTranslations(Matchers.anyString(), (LocaleId)Matchers.any(LocaleId.class), Matchers.anySetOf(String.class), Matchers.eq((boolean)this.getPullOpts().getCreateSkeletons()), (String)Matchers.any(String.class))).thenReturn((Object)this.transResourceResponse);
        Mockito.when((Object)this.transResourceResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.transResourceResponse.getStringHeaders()).thenReturn((Object)new MultivaluedMapImpl());
        Mockito.when((Object)this.transResourceResponse.readEntity(TranslationsResource.class)).thenReturn((Object)transResourceOnServer);
        return new PullCommand((PullOptions)this.pullOpts, this.clientFactory);
    }

    public RawPushCommand createRawPushCommand() {
        Mockito.when((Object)this.clientFactory.getFileResourceClient()).thenReturn((Object)this.fileResourceClient);
        List docTypeList = Arrays.stream(DocumentType.values()).map(DocumentType::toFileTypeInfo).collect(Collectors.toList());
        Mockito.when((Object)this.fileResourceClient.fileTypeInfoList()).thenReturn(docTypeList);
        ChunkUploadResponse uploadResponse = new ChunkUploadResponse(1L, 1, false, "Upload successful");
        Mockito.when((Object)this.fileResourceClient.uploadSourceFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), Matchers.anyString(), (DocumentFileUploadForm)Matchers.any(DocumentFileUploadForm.class))).thenReturn((Object)uploadResponse);
        Mockito.when((Object)this.fileResourceClient.uploadTranslationFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (DocumentFileUploadForm)Matchers.any(DocumentFileUploadForm.class))).thenReturn((Object)uploadResponse);
        return new RawPushCommand((PushOptions)this.pushOpts, this.clientFactory);
    }

    public void verifyPushRawFileSource(int numOfSource) {
        ((FileResourceClient)Mockito.verify((Object)this.fileResourceClient, (VerificationMode)Mockito.times((int)numOfSource))).uploadSourceFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), (String)this.docIdCaptor.capture(), (DocumentFileUploadForm)this.uploadFormCaptor.capture());
    }

    public void verifyPushRawFileTranslation(int numOfTrans) {
        ((FileResourceClient)Mockito.verify((Object)this.fileResourceClient, (VerificationMode)Mockito.times((int)numOfTrans))).uploadTranslationFile((String)Matchers.eq((Object)this.pushOpts.getProj()), (String)Matchers.eq((Object)this.pushOpts.getProjectVersion()), Matchers.anyString(), (String)this.docIdCaptor.capture(), Matchers.anyString(), (DocumentFileUploadForm)this.uploadFormCaptor.capture());
    }

    public RawPullCommand createRawPullCommand(List<ResourceMeta> remoteDocList, InputStream sourceFileStream, InputStream transFileStream) {
        Mockito.when((Object)this.clientFactory.getSourceDocResourceClient(this.pullOpts.getProj(), this.pullOpts.getProjectVersion())).thenReturn((Object)this.sourceDocClient);
        Mockito.when((Object)this.clientFactory.getFileResourceClient()).thenReturn((Object)this.fileResourceClient);
        Mockito.when((Object)this.sourceDocClient.getResourceMeta(null)).thenReturn(remoteDocList);
        Mockito.when((Object)this.fileResourceClient.downloadSourceFile((String)Matchers.eq((Object)this.pullOpts.getProj()), (String)Matchers.eq((Object)this.pullOpts.getProjectVersion()), (String)Matchers.eq((Object)"raw"), Matchers.anyString())).thenReturn((Object)this.downloadSourceResponse);
        Mockito.when((Object)this.downloadSourceResponse.getStatusInfo()).thenReturn((Object)Response.Status.OK);
        Mockito.when((Object)this.downloadSourceResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.downloadSourceResponse.readEntity(InputStream.class)).thenReturn((Object)sourceFileStream);
        Mockito.when((Object)this.fileResourceClient.downloadTranslationFile((String)Matchers.eq((Object)this.pullOpts.getProj()), (String)Matchers.eq((Object)this.pullOpts.getProjectVersion()), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)this.downloadTransResponse);
        Mockito.when((Object)this.downloadTransResponse.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)this.downloadTransResponse.getHeaders()).thenReturn((Object)new MultivaluedMapImpl());
        Mockito.when((Object)this.downloadTransResponse.getStatusInfo()).thenReturn((Object)Response.Status.OK);
        Mockito.when((Object)this.downloadTransResponse.readEntity(InputStream.class)).thenReturn((Object)transFileStream);
        return new RawPullCommand((PullOptions)this.pullOpts, this.fileResourceClient, this.clientFactory);
    }
}

