/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.TempTransFileRule;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.commands.pull.RawPullStrategy;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleMapping;

public class RawPullStrategyTest {
    @Rule
    public TempTransFileRule tempTransFileRule = new TempTransFileRule();
    private RawPullStrategy strategy;
    private PullOptionsImpl opts;
    @Mock
    private InputStream transFile;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.strategy = new RawPullStrategy();
        this.opts = new PullOptionsImpl();
        this.opts.setTransDir(this.tempTransFileRule.getTransDir());
        this.opts.setProjectType("file");
        this.strategy.setPullOptions((PullOptions)this.opts);
    }

    @Test
    public void canWriteToFileWithoutMapping() throws IOException {
        Mockito.when((Object)this.transFile.read((byte[])Matchers.any(byte[].class))).thenReturn((Object)-1);
        this.strategy.writeTransFile("foo/test.odt", new LocaleMapping("de"), this.transFile, Optional.absent());
        Assertions.assertThat((boolean)new File(this.tempTransFileRule.getTransDir(), "de/foo/test.odt").exists()).isTrue();
    }

    @Test
    public void canWriteToFileWithMapping() throws IOException {
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("{locale}/{filename}.{extension}")}));
        Mockito.when((Object)this.transFile.read((byte[])Matchers.any(byte[].class))).thenReturn((Object)-1);
        this.strategy.writeTransFile("foo/test.odt", new LocaleMapping("de"), this.transFile, Optional.absent());
        Assertions.assertThat((boolean)new File(this.tempTransFileRule.getTransDir(), "de/test.odt").exists()).isTrue();
    }
}

