/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.init;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConsoleInteractor;
import org.zanata.client.commands.MockConsoleInteractor;
import org.zanata.client.commands.init.InitOptions;
import org.zanata.client.commands.init.InitOptionsImpl;
import org.zanata.client.commands.init.ProjectIterationPrompt;
import org.zanata.client.commands.init.ProjectPrompt;
import org.zanata.common.EntityStatus;
import org.zanata.rest.client.ProjectClient;
import org.zanata.rest.client.ProjectsClient;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.Project;
import org.zanata.rest.dto.ProjectIteration;

public class ProjectPromptTest {
    private ProjectPrompt prompt;
    private InitOptions opts;
    @Mock
    private ProjectIterationPrompt iterationPrompt;
    @Captor
    private ArgumentCaptor<Project> projectCaptor;
    @Mock
    private RestClientFactory clientFactory;
    @Mock
    private ProjectsClient projectsClient;
    @Mock
    private ProjectClient projectClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.opts = new InitOptionsImpl();
        Mockito.when((Object)this.clientFactory.getProjectsClient()).thenReturn((Object)this.projectsClient);
    }

    @Test
    public void willShowAllActiveProjectsIfUserChooseToSelect() throws IOException {
        Project project = new Project("gcc", "gnu C compiler", "gettext");
        ProjectIteration iteration = new ProjectIteration("master");
        iteration.setStatus(EntityStatus.ACTIVE);
        project.getIterations(true).add(iteration);
        Mockito.when((Object)this.projectsClient.getProjects()).thenReturn((Object)new Project[]{project});
        Mockito.when((Object)this.clientFactory.getProjectClient("gcc")).thenReturn((Object)this.projectClient);
        Mockito.when((Object)this.projectClient.get()).thenReturn((Object)project);
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("1", "1", "1", "1");
        this.prompt = new ProjectPrompt(console, this.opts, new ProjectIterationPrompt(console, this.opts, this.clientFactory), this.clientFactory);
        this.prompt.selectOrCreateNewProjectAndVersion();
        Assertions.assertThat((String)this.opts.getProj()).isEqualTo((Object)"gcc");
        Assertions.assertThat((String)this.opts.getProjectType()).isEqualTo((Object)"gettext");
        Assertions.assertThat((String)this.opts.getProjectVersion()).isEqualTo((Object)"master");
    }

    @Test
    public void willFilterAllProjectsIfUserTypeLetters() {
        Mockito.when((Object)this.projectsClient.getProjects()).thenReturn((Object)new Project[]{ProjectPromptTest.makeProject("project-1", "project one"), ProjectPromptTest.makeProject("project-2", "project two"), ProjectPromptTest.makeProject("project-99", "project 99")});
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("99", "1");
        this.prompt = new ProjectPrompt(console, this.opts, (ProjectIterationPrompt)Mockito.mock(ProjectIterationPrompt.class), this.clientFactory);
        this.prompt.selectProject();
        Assertions.assertThat((String)this.opts.getProj()).isEqualTo((Object)"project-99");
        Assertions.assertThat((String)this.opts.getProjectType()).isEqualTo((Object)"gettext");
    }

    private static Project makeProject(String slug, String name) {
        Project project = new Project();
        project.setId(slug);
        project.setName(name);
        project.setDefaultType("gettext");
        return project;
    }

    @Test
    public void canFilterProject() {
        this.prompt = new ProjectPrompt((ConsoleInteractor)Mockito.mock(ConsoleInteractor.class), this.opts, (ProjectIterationPrompt)Mockito.mock(ProjectIterationPrompt.class), this.clientFactory);
        Project gcc = ProjectPromptTest.makeProject("gcc", "gnu c compiler");
        Project aboutFedora = ProjectPromptTest.makeProject("about-fedora", "about fedora");
        Project ibus = ProjectPromptTest.makeProject("ibus-pinyin", "ibus pinyin input method");
        Project tar = ProjectPromptTest.makeProject("gnu-tar", "tar");
        ArrayList allProjects = Lists.newArrayList((Object[])new Project[]{gcc, aboutFedora, ibus, tar});
        ArrayList filteredProjects = Lists.newArrayList((Object[])new Project[]{gcc, ibus, tar});
        this.prompt.setAllProjectsAndFilteredProjects((List)allProjects, (List)filteredProjects);
        Assertions.assertThat((List)this.prompt.filterBy("")).isEqualTo((Object)allProjects);
        Assertions.assertThat((List)this.prompt.filterBy("gnu")).contains((Object[])new Project[]{gcc, tar});
        Assertions.assertThat((List)this.prompt.filterBy("bus")).contains((Object[])new Project[]{ibus});
    }

    @Test
    public void willGuideUserIfUserChooseToCreateNewProjectAndVersion() throws IOException {
        String projectId = "gcc";
        String projectType = "gettext";
        String versionId = "master";
        ConsoleInteractor console = MockConsoleInteractor.predefineAnswers("gcc", "C compiler", "gettext", "master");
        Mockito.when((Object)this.clientFactory.getProjectClient("gcc")).thenReturn((Object)this.projectClient);
        Mockito.when((Object)this.projectClient.put((Project)this.projectCaptor.capture())).thenReturn((Object)Response.created(null).build());
        this.prompt = new ProjectPrompt(console, this.opts, this.iterationPrompt, this.clientFactory);
        this.prompt.createNewProject();
        ((ProjectClient)Mockito.verify((Object)this.projectClient)).put((Project)this.projectCaptor.capture());
        ((ProjectIterationPrompt)Mockito.verify((Object)this.iterationPrompt)).createNewVersion();
        Project project = (Project)this.projectCaptor.getValue();
        Assertions.assertThat((String)project.getId()).isEqualTo((Object)"gcc");
        Assertions.assertThat((String)project.getName()).isEqualTo((Object)"C compiler");
        Assertions.assertThat((String)project.getDefaultType()).isEqualTo((Object)"gettext");
    }
}

