/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.zanata.client.TestUtils;
import org.zanata.client.commands.ConfigurableProjectOptions;
import org.zanata.client.commands.pull.PropertiesStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullOptionsImpl;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;

public class PropertiesStrategyPullTest {
    private PropertiesStrategy strategy;
    private PullOptionsImpl opts;

    @Before
    public void setUp() {
        this.opts = new PullOptionsImpl();
        this.opts.setLocaleMapList(new LocaleList());
        this.opts.setProjectType("properties");
        this.strategy = new PropertiesStrategy((PullOptions)this.opts);
    }

    @Test
    public void canGetTransFileWithoutMappingRule() {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        File deTransFile = this.strategy.getTransFileToWrite("src/main/resources/msg", deMapping);
        Assertions.assertThat((File)deTransFile).isEqualTo((Object)new File(this.opts.getTransDir(), "src/main/resources/msg_de.properties"));
        File zhTransFile = this.strategy.getTransFileToWrite("src/main/resources/msg", zhMapping);
        Assertions.assertThat((File)zhTransFile).isEqualTo((Object)new File(this.opts.getTransDir(), "src/main/resources/msg_zh_Hans.properties"));
    }

    @Test
    public void canGetTransFileWithMappingRule() {
        LocaleMapping deMapping = TestUtils.createAndAddLocaleMapping("de", (Optional<String>)Optional.absent(), (ConfigurableProjectOptions)this.opts);
        LocaleMapping zhMapping = TestUtils.createAndAddLocaleMapping("zh-CN", (Optional<String>)Optional.of((Object)"zh-Hans"), (ConfigurableProjectOptions)this.opts);
        this.opts.setFileMappingRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("{path}/{filename}_{locale_with_underscore}.properties")}));
        File deTransFile = this.strategy.getTransFileToWrite("src/main/resources/msg", deMapping);
        Assertions.assertThat((File)deTransFile).isEqualTo((Object)new File(this.opts.getTransDir(), "src/main/resources/msg_de.properties"));
        File zhTransFile = this.strategy.getTransFileToWrite("src/main/resources/msg", zhMapping);
        Assertions.assertThat((File)zhTransFile).isEqualTo((Object)new File(this.opts.getTransDir(), "src/main/resources/msg_zh_Hans.properties"));
    }
}

