/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.zanata.client.config.FileMappingRule;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.config.ZanataConfig;

public class ZanataConfigTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ZanataConfig.class});
    Unmarshaller unmarshaller = this.jc.createUnmarshaller();
    Marshaller marshaller = this.jc.createMarshaller();
    File zanataProjectXml;
    File zanataUserFile;

    public ZanataConfigTest() throws Exception {
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
    }

    @Before
    public void setUp() throws IOException {
        this.zanataProjectXml = new File(this.tempFolder.newFolder(), "zanata.xml");
        this.zanataUserFile = new File(this.tempFolder.newFolder(), "zanata.ini");
    }

    @Test
    public void testWriteReadProject() throws Exception {
        this.writeProject();
        this.readProject();
    }

    void writeProject() throws Exception {
        ZanataConfig config = new ZanataConfig();
        config.setUrl(new URL("http://example.com"));
        config.setProject("project");
        config.setProjectVersion("version");
        config.getLocales().add(new LocaleMapping("fr", "fr-FR"));
        config.getLocales().add(new LocaleMapping("  zh-CN  "));
        this.marshaller.marshal((Object)config, this.zanataProjectXml);
    }

    void readProject() throws Exception {
        ZanataConfig config = (ZanataConfig)this.unmarshaller.unmarshal(this.zanataProjectXml);
        Assertions.assertThat((URL)config.getUrl()).isEqualTo((Object)new URL("http://example.com"));
        Assertions.assertThat((String)config.getProject()).isEqualTo((Object)"project");
        Assertions.assertThat((String)config.getProjectVersion()).isEqualTo((Object)"version");
        LocaleList locales = config.getLocales();
        Assertions.assertThat((List)locales).hasSize(2);
        Assertions.assertThat((String)locales.get(0).getLocale()).isEqualTo((Object)"fr");
        Assertions.assertThat((String)locales.get(0).getMapFrom()).isEqualTo((Object)"fr-FR");
        Assertions.assertThat((String)locales.get(1).getLocale()).isEqualTo((Object)"zh-CN");
        Assertions.assertThat((String)locales.get(1).getMapFrom()).isNull();
    }

    @Test
    public void testWriteReadUser() throws Exception {
        this.writeUser();
        this.readUser();
    }

    void writeUser() throws Exception {
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration(this.zanataUserFile);
        config.setProperty("zanata.url", (Object)new URL("http://zanata.example.com/"));
        config.setProperty("zanata.username", (Object)"admin");
        config.setProperty("zanata.key", (Object)"b6d7044e9ee3b2447c28fb7c50d86d98");
        config.setProperty("zanata.debug", (Object)false);
        config.setProperty("zanata.errors", (Object)true);
        config.save();
    }

    void readUser() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addConfiguration((Configuration)new SystemConfiguration());
        config.addConfiguration((Configuration)new HierarchicalINIConfiguration(this.zanataUserFile));
        Assertions.assertThat((String)config.getString("zanata.username")).isEqualTo((Object)"admin");
        Assertions.assertThat((boolean)config.getBoolean("zanata.debug")).isFalse();
        Assertions.assertThat((boolean)config.getBoolean("zanata.errors")).isTrue();
    }

    @Test
    public void canReadAndWriteRules() throws Exception {
        ZanataConfig zanataConfig = new ZanataConfig();
        zanataConfig.setRules((List)Lists.newArrayList((Object[])new FileMappingRule[]{new FileMappingRule("*.odt", "{filename}_{locale}.{extension}")}));
        this.marshaller.marshal((Object)zanataConfig, this.zanataProjectXml);
        ZanataConfig config = (ZanataConfig)this.unmarshaller.unmarshal(this.zanataProjectXml);
        Assertions.assertThat((List)config.getRules()).hasSize(1);
        FileMappingRule rule = (FileMappingRule)config.getRules().get(0);
        Assertions.assertThat((String)rule.getPattern()).isEqualTo((Object)"*.odt");
        Assertions.assertThat((String)rule.getRule()).isEqualTo((Object)"{filename}_{locale}.{extension}");
    }
}

