/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.hystrix.bundle;

import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import io.dropwizard.Bundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixBundle
implements Bundle {
    public static final String DEFAULT_STREAM_PATH = "/hystrix.stream";
    public static final String SERVLET_NAME = "hystrixMetricsStream";
    private static final Logger logger = LoggerFactory.getLogger(HystrixBundle.class);
    private final String adminStreamPath;
    private final String applicationStreamUri;
    private final boolean publishHystrixMetrics;

    HystrixBundle(String adminStreamPath, String applicationStreamUri, boolean publishHystrixMetrics) {
        this.adminStreamPath = adminStreamPath;
        this.applicationStreamUri = applicationStreamUri;
        this.publishHystrixMetrics = publishHystrixMetrics;
    }

    public static HystrixBundle withDefaultSettings() {
        return HystrixBundle.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void initialize(Bootstrap<?> bootstrap) {
        logger.debug("Resetting Hystrix before changing the configuration");
        HystrixPlugins.reset();
    }

    public void run(Environment environment) {
        if (this.adminStreamPath != null) {
            logger.info("Mapping \"{}\" to the HystrixMetricsStreamServlet in the admin context", (Object)this.adminStreamPath);
            environment.getAdminContext().addServlet(new ServletHolder(SERVLET_NAME, (Servlet)new HystrixMetricsStreamServlet()), this.adminStreamPath);
        }
        if (this.applicationStreamUri != null) {
            logger.info("Mapping \"{}\" to the HystrixMetricsStreamServlet in the application context", (Object)this.applicationStreamUri);
            environment.getApplicationContext().addServlet(new ServletHolder(SERVLET_NAME, (Servlet)new HystrixMetricsStreamServlet()), this.applicationStreamUri);
        }
        if (this.publishHystrixMetrics) {
            logger.info("Enabling the Hystrix to DropWizard metrics publisher");
            HystrixCodaHaleMetricsPublisher metricsPublisher = new HystrixCodaHaleMetricsPublisher(environment.metrics());
            HystrixPlugins.getInstance().registerMetricsPublisher((HystrixMetricsPublisher)metricsPublisher);
        } else {
            logger.info("The Hystrix to DropWizard metrics publisher is disabled");
        }
    }

    public static class Builder {
        private String adminPath = "/hystrix.stream";
        private String applicationPath;
        private boolean publishHystrixMetrics = true;

        public Builder withAdminStreamUri(String path) {
            this.adminPath = path;
            return this;
        }

        public Builder disableStreamServletInAdminContext() {
            this.adminPath = null;
            return this;
        }

        public Builder withApplicationStreamPath(String path) {
            this.applicationPath = path;
            return this;
        }

        public Builder disableMetricsPublisher() {
            this.publishHystrixMetrics = false;
            return this;
        }

        public HystrixBundle build() {
            return new HystrixBundle(this.adminPath, this.applicationPath, this.publishHystrixMetrics);
        }
    }
}

