/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.hystrix.bundle;

import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Objects;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    static final String DEFAULT_STREAM_PATH = "/hystrix.stream";
    static final boolean DEFAULT_PUBLISH_HYSTRIX_METRICS = true;
    static final String SERVLET_NAME = "hystrixMetricsStream";
    static final MetricsPublishPredicate DEFAULT_PUBLISH_PREDICATE = c -> true;
    private static final Logger logger = LoggerFactory.getLogger(HystrixBundle.class);
    private final String adminStreamPath;
    private final String applicationStreamUri;
    private final MetricsPublishPredicate publishPredicate;

    public HystrixBundle() {
        this(DEFAULT_STREAM_PATH, null, DEFAULT_PUBLISH_PREDICATE);
    }

    private HystrixBundle(String adminStreamPath, String applicationStreamUri, MetricsPublishPredicate publishPredicate) {
        this.adminStreamPath = adminStreamPath;
        this.applicationStreamUri = applicationStreamUri;
        this.publishPredicate = publishPredicate;
    }

    public static HystrixBundle withDefaultSettings() {
        return HystrixBundle.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void initialize(Bootstrap<?> bootstrap) {
        logger.debug("Resetting Hystrix before changing the configuration");
        HystrixPlugins.reset();
    }

    public void run(T configuration, Environment environment) {
        if (this.adminStreamPath != null) {
            logger.info("Mapping \"{}\" to the HystrixMetricsStreamServlet in the admin context", (Object)this.adminStreamPath);
            environment.getAdminContext().addServlet(new ServletHolder(SERVLET_NAME, (Servlet)new HystrixMetricsStreamServlet()), this.adminStreamPath);
        }
        if (this.applicationStreamUri != null) {
            logger.info("Mapping \"{}\" to the HystrixMetricsStreamServlet in the application context", (Object)this.applicationStreamUri);
            environment.getApplicationContext().addServlet(new ServletHolder(SERVLET_NAME, (Servlet)new HystrixMetricsStreamServlet()), this.applicationStreamUri);
        }
        if (this.publishPredicate.enabled(configuration)) {
            logger.info("Enabling the Hystrix to DropWizard metrics publisher");
            HystrixCodaHaleMetricsPublisher metricsPublisher = new HystrixCodaHaleMetricsPublisher(environment.metrics());
            HystrixPlugins.getInstance().registerMetricsPublisher((HystrixMetricsPublisher)metricsPublisher);
        } else {
            logger.info("The Hystrix to DropWizard metrics publisher is disabled");
        }
    }

    public static class Builder {
        private String adminPath = "/hystrix.stream";
        private String applicationPath;
        private MetricsPublishPredicate metricsPublishPredicate = DEFAULT_PUBLISH_PREDICATE;

        public Builder withAdminStreamUri(String path) {
            this.adminPath = path;
            return this;
        }

        public Builder disableStreamServletInAdminContext() {
            this.adminPath = null;
            return this;
        }

        public Builder withApplicationStreamPath(String path) {
            this.applicationPath = path;
            return this;
        }

        public Builder disableMetricsPublisher() {
            return this.withMetricsPublisherPredicate(c -> false);
        }

        public Builder withMetricsPublisherPredicate(MetricsPublishPredicate metricsPublisherPredicate) {
            Objects.nonNull(metricsPublisherPredicate);
            this.metricsPublishPredicate = metricsPublisherPredicate;
            return this;
        }

        public HystrixBundle build() {
            return new HystrixBundle(this.adminPath, this.applicationPath, this.metricsPublishPredicate);
        }
    }

    @FunctionalInterface
    public static interface MetricsPublishPredicate<V extends Configuration> {
        public boolean enabled(V var1);
    }
}

