/*
 * Decompiled with CFR 0.152.
 */
package org.zbus.remoting;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zbus.remoting.ClientDispatcherManager;
import org.zbus.remoting.ClientEventAdaptor;
import org.zbus.remoting.Message;
import org.zbus.remoting.callback.ConnectedCallback;
import org.zbus.remoting.callback.ErrorCallback;
import org.zbus.remoting.callback.MessageCallback;
import org.zbus.remoting.nio.Session;
import org.zbus.remoting.ticket.ResultCallback;
import org.zbus.remoting.ticket.Ticket;
import org.zbus.remoting.ticket.TicketManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingClient {
    private static final Logger log = LoggerFactory.getLogger(RemotingClient.class);
    protected final ClientDispatcherManager dispatcherManager;
    private static volatile ClientDispatcherManager defaultDispactherManager = null;
    protected String serverHost = "127.0.0.1";
    protected int serverPort = 15555;
    protected Session session;
    protected int readTimeout = 3000;
    protected int connectTimeout = 3000;
    private ConcurrentMap<String, Object> attributes = null;
    protected MessageCallback messageCallback;
    protected ConnectedCallback connectedCallback;
    protected ErrorCallback errorCallback;
    protected final ScheduledExecutorService heartbeator = Executors.newSingleThreadScheduledExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ClientDispatcherManager getDefaultDispatcherManager() {
        if (defaultDispactherManager != null) return defaultDispactherManager;
        Class<RemotingClient> clazz = RemotingClient.class;
        synchronized (RemotingClient.class) {
            if (defaultDispactherManager != null) return defaultDispactherManager;
            try {
                defaultDispactherManager = new ClientDispatcherManager();
                defaultDispactherManager.start();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return defaultDispactherManager;
        }
    }

    public RemotingClient(String serverHost, int serverPort) {
        this(serverHost, serverPort, RemotingClient.getDefaultDispatcherManager());
    }

    public RemotingClient(String serverHost, int serverPort, ClientDispatcherManager dispatcherManager) {
        this(String.format("%s:%d", serverHost, serverPort), dispatcherManager);
    }

    public RemotingClient(String address) {
        this(address, RemotingClient.getDefaultDispatcherManager());
    }

    public RemotingClient(String address, ClientDispatcherManager dispatcherManager) {
        String[] blocks;
        if (dispatcherManager == null) {
            dispatcherManager = RemotingClient.getDefaultDispatcherManager();
        }
        if ((blocks = address.split("[:]")).length > 2) {
            throw new IllegalArgumentException("Illegal address: " + address);
        }
        if (!dispatcherManager.isStarted()) {
            throw new IllegalStateException("ClientDispachterManager not started yet");
        }
        this.serverHost = blocks[0].trim();
        if (blocks.length > 1) {
            this.serverPort = Integer.valueOf(blocks[1].trim());
        }
        this.dispatcherManager = dispatcherManager;
        this.heartbeator.scheduleAtFixedRate(new Runnable(){

            public void run() {
                if (RemotingClient.this.hasConnected()) {
                    Message hbt = new Message();
                    hbt.setCommand("heartbeat");
                    try {
                        RemotingClient.this.send(hbt);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }, 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    protected void initCallback() throws IOException {
        if (this.connectedCallback != null) {
            this.onConnected(this.connectedCallback);
        }
        if (this.errorCallback != null) {
            this.onError(this.errorCallback);
        }
        if (this.messageCallback != null) {
            this.onMessage(this.messageCallback);
        }
    }

    protected Session doConnect() throws IOException {
        if (this.session != null && (this.session.isActive() || this.session.isNew())) {
            return this.session;
        }
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        channel.connect(new InetSocketAddress(this.serverHost, this.serverPort));
        this.session = new Session(this.dispatcherManager, channel, this.dispatcherManager.buildEventAdaptor());
        this.initCallback();
        this.dispatcherManager.registerSession(8, this.session);
        return this.session;
    }

    public void connect(int timeoutMillis) throws IOException {
        this.session = this.doConnect();
        this.session.waitToConnect(timeoutMillis);
    }

    public boolean hasConnected() {
        return this.session != null && this.session.isActive();
    }

    public void ensureConnected() {
        while (!this.hasConnected()) {
            try {
                this.connect(this.connectTimeout);
            }
            catch (IOException e) {
                log.info(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void connectIfNeed() throws IOException {
        if (!this.hasConnected()) {
            this.connect(this.connectTimeout);
        }
        if (!this.hasConnected()) {
            throw new IOException("Connection failed");
        }
    }

    public void invokeAsync(Message req, ResultCallback callback) throws IOException {
        this.connectIfNeed();
        Ticket ticket = null;
        if (callback != null) {
            ticket = TicketManager.createTicket(req, this.readTimeout, callback);
        } else if ("".equals(req.getMsgId()) || req.getMsgId() == null) {
            req.setMsgId(Ticket.uuidTicket());
        }
        try {
            this.session.write(req);
        }
        catch (IOException e) {
            if (ticket != null) {
                TicketManager.removeTicket(ticket.getId());
            }
            throw e;
        }
    }

    public Message invokeSync(Message req) throws IOException {
        return this.invokeSync(req, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invokeSync(Message req, int timeout) throws IOException {
        Ticket ticket = null;
        try {
            this.connectIfNeed();
            ticket = TicketManager.createTicket(req, timeout);
            this.session.write(req);
            if (!ticket.await(timeout, TimeUnit.MILLISECONDS)) {
                if (!this.session.isActive()) {
                    throw new IOException("Connection reset by peer");
                }
                Message message = null;
                return message;
            }
            Message message = ticket.response();
            return message;
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ticket != null) {
                TicketManager.removeTicket(ticket.getId());
            }
        }
        return null;
    }

    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.heartbeator.shutdown();
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Session getSession() {
        return this.session;
    }

    public <T> T attr(String key) {
        if (this.attributes == null) {
            return null;
        }
        return (T)this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void attr(String key, T value) {
        if (this.attributes == null) {
            RemotingClient remotingClient = this;
            synchronized (remotingClient) {
                if (this.attributes == null) {
                    this.attributes = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        this.attributes.put(key, value);
    }

    public void send(Message msg) throws IOException {
        this.connectIfNeed();
        if ("".equals(msg.getMsgId()) || msg.getMsgId() == null) {
            msg.setMsgId(Ticket.uuidTicket());
        }
        this.session.write(msg);
    }

    public void onMessage(MessageCallback messageCallback) {
        this.messageCallback = messageCallback;
        if (this.session != null && this.messageCallback != null) {
            ClientEventAdaptor handler = (ClientEventAdaptor)this.session.getEventAdaptor();
            handler.setMessageCallback(this.messageCallback);
        }
    }

    public void onError(ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
        if (this.session != null && this.errorCallback != null) {
            ClientEventAdaptor handler = (ClientEventAdaptor)this.session.getEventAdaptor();
            handler.setErrorCallback(errorCallback);
        }
    }

    public void onConnected(ConnectedCallback connectedCallback) {
        this.connectedCallback = connectedCallback;
        if (this.session != null && connectedCallback != null) {
            ClientEventAdaptor handler = (ClientEventAdaptor)this.session.getEventAdaptor();
            handler.setConnectedCallback(connectedCallback);
        }
    }
}

