/*
 * Decompiled with CFR 0.152.
 */
package org.zbus.remoting;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zbus.remoting.Helper;
import org.zbus.remoting.ServerDispatcherManager;
import org.zbus.remoting.ServerEventAdaptor;

public class RemotingServer
extends ServerEventAdaptor {
    private static final Logger log = LoggerFactory.getLogger(RemotingServer.class);
    protected String serverHost = "0.0.0.0";
    protected int serverPort = 15555;
    protected String serverAddr = String.format("%s:%d", this.serverHost, this.serverPort);
    protected String serverName = "RemoteServer";
    protected ServerDispatcherManager dispatcherManager;

    public RemotingServer(String serverHost) {
        this(serverHost, 15555);
    }

    public RemotingServer(int serverPort) {
        this("0.0.0.0", serverPort);
    }

    public RemotingServer(String serverHost, int serverPort) {
        try {
            this.dispatcherManager = new ServerDispatcherManager(this);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.serverAddr = "0.0.0.0".equals(this.serverHost) ? String.format("%s:%d", Helper.getLocalIp(), this.serverPort) : String.format("%s:%d", this.serverHost, this.serverPort);
    }

    public void init() {
    }

    public void start() throws Exception {
        this.init();
        if (!this.dispatcherManager.isStarted()) {
            this.dispatcherManager.start();
        }
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.configureBlocking(false);
        channel.socket().bind(new InetSocketAddress(this.serverHost, this.serverPort));
        this.dispatcherManager.getDispatcher(0).registerChannel(channel, 16);
        log.info("{} serving@{}:{}", new Object[]{this.serverName, this.serverHost, this.serverPort});
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
}

