/*
 * Decompiled with CFR 0.152.
 */
package org.zbus.remoting.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zbus.remoting.Helper;
import org.zbus.remoting.nio.DispatcherManager;
import org.zbus.remoting.nio.Session;

public class Dispatcher
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);
    protected volatile Selector selector = null;
    protected final DispatcherManager dispatcherManager;
    private final Queue<Object[]> register = new LinkedBlockingQueue<Object[]>();
    private final Queue<Session> unregister = new LinkedBlockingQueue<Session>();

    public Dispatcher(DispatcherManager dispatcherManager, String name) throws IOException {
        super(name);
        this.dispatcherManager = dispatcherManager;
        this.selector = Selector.open();
    }

    public Dispatcher(DispatcherManager dispatcherManager) throws IOException {
        this(dispatcherManager, "Dispatcher");
    }

    public void registerChannel(SelectableChannel channel, int ops) throws IOException {
        this.registerChannel(channel, ops, null);
    }

    public void registerSession(int ops, Session sess) throws IOException {
        this.registerChannel(sess.getChannel(), ops, sess);
    }

    public void registerChannel(SelectableChannel channel, int ops, Session sess) throws IOException {
        if (Thread.currentThread() == this) {
            SelectionKey key = channel.register(this.selector, ops, sess);
            if (sess != null) {
                sess.setRegisteredKey(key);
                sess.setStatus(Session.SessionStatus.CONNECTED);
                sess.getEventAdaptor().onSessionRegistered(sess);
            }
        } else {
            this.register.offer(new Object[]{channel, ops, sess});
            this.selector.wakeup();
        }
    }

    public void unregisterSession(Session sess) {
        if (this.unregister.contains(sess)) {
            return;
        }
        this.unregister.add(sess);
        this.selector.wakeup();
    }

    public void interrupt() {
        super.interrupt();
        try {
            this.selector.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void run() {
        try {
            while (true) {
                this.selector.select();
                this.handleRegister();
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid()) continue;
                    Object att = key.attachment();
                    if (att != null && att instanceof Session) {
                        ((Session)att).updateLastOperationTime();
                    }
                    try {
                        if (key.isAcceptable()) {
                            this.handleAcceptEvent(key);
                            continue;
                        }
                        if (key.isConnectable()) {
                            this.handleConnectEvent(key);
                            continue;
                        }
                        if (key.isReadable()) {
                            this.handleReadEvent(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        this.handleWriteEvent(key);
                    }
                    catch (Throwable e) {
                        this.disconnectWithException(key, e);
                    }
                }
                this.handleUnregister();
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return;
        }
    }

    private void disconnectWithException(SelectionKey key, Throwable e) {
        Session sess = (Session)key.attachment();
        try {
            sess.setStatus(Session.SessionStatus.ON_ERROR);
            sess.getEventAdaptor().onException(e, sess);
        }
        catch (Throwable ex) {
            log.error(e.getMessage(), ex);
        }
        try {
            if (sess != null) {
                sess.close();
            } else {
                key.channel().close();
            }
            key.cancel();
        }
        catch (Throwable ex) {
            log.error(e.getMessage(), ex);
        }
    }

    protected void handleRegister() {
        Object[] item = null;
        while ((item = this.register.poll()) != null) {
            try {
                SelectableChannel channel = (SelectableChannel)item[0];
                if (!channel.isOpen()) continue;
                int ops = (Integer)item[1];
                Session sess = (Session)item[2];
                SelectionKey key = channel.register(this.selector, ops, sess);
                if (sess == null) continue;
                sess.setRegisteredKey(key);
                sess.getEventAdaptor().onSessionRegistered(sess);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void handleUnregister() {
        Session sess = null;
        while ((sess = this.unregister.poll()) != null) {
            try {
                sess.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void handleAcceptEvent(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        channel.configureBlocking(false);
        if (log.isDebugEnabled()) {
            log.debug("ACCEPT: {}=>{}", (Object)Helper.remoteAddress(channel), (Object)Helper.localAddress(channel));
        }
        Session sess = new Session(this.dispatcherManager, channel, this.dispatcherManager.buildEventAdaptor());
        sess.setStatus(Session.SessionStatus.CONNECTED);
        sess.getEventAdaptor().onSessionAccepted(sess);
    }

    protected void handleConnectEvent(SelectionKey key) throws IOException {
        Session sess;
        SocketChannel channel = (SocketChannel)key.channel();
        if (log.isDebugEnabled()) {
            log.debug("CONNECT: {}=>{}", (Object)Helper.localAddress(channel), (Object)Helper.remoteAddress(channel));
        }
        if ((sess = (Session)key.attachment()) == null) {
            throw new IOException("Session not attached yet to SelectionKey");
        }
        if (channel.finishConnect()) {
            sess.finishConnect();
        }
        sess.setStatus(Session.SessionStatus.CONNECTED);
        key.interestOps(0);
        sess.getEventAdaptor().onSessionConnected(sess);
    }

    protected void handleReadEvent(SelectionKey key) throws IOException {
        Session sess = (Session)key.attachment();
        if (sess == null) {
            throw new IOException("Session not attached yet to SelectionKey");
        }
        SocketChannel channel = sess.getChannel();
        if (log.isDebugEnabled()) {
            log.debug("READ: {}=>{}", (Object)Helper.remoteAddress(channel), (Object)Helper.localAddress(channel));
        }
        sess.doRead();
    }

    protected void handleWriteEvent(SelectionKey key) throws IOException {
        Session sess = (Session)key.attachment();
        if (sess == null) {
            throw new IOException("Session not attached yet to SelectionKey");
        }
        SocketChannel channel = sess.getChannel();
        if (log.isDebugEnabled()) {
            log.debug("WRITE: {}=>{}", (Object)Helper.remoteAddress(channel), (Object)Helper.localAddress(channel));
        }
        sess.doWrite();
    }
}

