/*
 * Decompiled with CFR 0.152.
 */
package org.zbus.remoting.nio;

import java.io.IOException;
import org.zbus.remoting.nio.Session;

public abstract class EventAdaptor {
    public void onSessionAccepted(Session sess) throws IOException {
        sess.dispatcherManager().registerSession(1, sess);
    }

    public void onSessionRegistered(Session sess) throws IOException {
    }

    public void onSessionConnected(Session sess) throws IOException {
        sess.interestOps(5);
    }

    public void onSessionDestroyed(Session sess) throws IOException {
    }

    public abstract void onMessage(Object var1, Session var2) throws IOException;

    public void onException(Throwable e, Session sess) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e.getMessage(), e);
    }
}

