/*
 * Decompiled with CFR 0.152.
 */
package org.zbus.remoting.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zbus.remoting.Helper;
import org.zbus.remoting.nio.Dispatcher;
import org.zbus.remoting.nio.DispatcherManager;
import org.zbus.remoting.nio.EventAdaptor;
import org.zbus.remoting.nio.IoBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private SessionStatus status = SessionStatus.NEW;
    private long lastOperationTime = System.currentTimeMillis();
    private final String id;
    private int bufferSize = 8192;
    private IoBuffer readBuffer = null;
    private Queue<ByteBuffer> writeBufferQ = new LinkedBlockingQueue<ByteBuffer>();
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private final DispatcherManager dispatcherManager;
    private final SocketChannel channel;
    private SelectionKey registeredKey = null;
    private ConcurrentMap<String, Object> attributes = null;
    private Object attachment;
    private final EventAdaptor eventAdaptor;

    public Session(DispatcherManager dispatcherManager, SocketChannel channel, EventAdaptor eventAdaptor) {
        this(dispatcherManager, channel, null, eventAdaptor);
    }

    public Session(DispatcherManager dispatcherManager, SocketChannel channel, Object attachment, EventAdaptor eventAdaptor) {
        this.dispatcherManager = dispatcherManager;
        this.id = UUID.randomUUID().toString();
        this.channel = channel;
        this.attachment = attachment;
        this.eventAdaptor = eventAdaptor;
    }

    public String id() {
        return "" + this.id;
    }

    public void close() throws IOException {
        if (this.status == SessionStatus.CLOSED) {
            return;
        }
        this.status = SessionStatus.CLOSED;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.registeredKey != null) {
            this.registeredKey.cancel();
            this.registeredKey = null;
        }
    }

    public void asyncClose() throws IOException {
        if (this.registeredKey == null) {
            return;
        }
        Dispatcher dispatcher = this.dispatcherManager.getDispatcher(this.registeredKey);
        if (dispatcher == null) {
            throw new IOException("failed to find dispatcher for session: " + this);
        }
        dispatcher.unregisterSession(this);
    }

    public void write(Object msg) throws IOException {
        this.write(this.dispatcherManager.getCodec().encode(msg));
    }

    public void write(IoBuffer buf) throws IOException {
        if (this.registeredKey == null) {
            throw new IOException("Session not registered yet:" + this);
        }
        if (!this.writeBufferQ.offer(buf.buf())) {
            String msg = "Session write buffer queue is full, message count=" + this.writeBufferQ.size();
            log.warn(msg);
            throw new IOException(msg);
        }
        this.registeredKey.interestOps(this.registeredKey.interestOps() | 4);
        this.registeredKey.selector().wakeup();
    }

    public void doRead() throws IOException {
        if (this.readBuffer == null) {
            this.readBuffer = IoBuffer.allocate(this.bufferSize);
        }
        ByteBuffer data = ByteBuffer.allocate(4096);
        int n = 0;
        while ((n = this.channel.read(data)) > 0) {
            data.flip();
            this.readBuffer.put(data.array(), data.position(), data.remaining());
            data.clear();
        }
        if (n < 0) {
            this.eventAdaptor.onSessionDestroyed(this);
            this.asyncClose();
            return;
        }
        IoBuffer tempBuf = this.readBuffer.duplicate().flip();
        Object msg = null;
        while (true) {
            tempBuf.mark();
            msg = tempBuf.remaining() > 0 ? this.dispatcherManager.getCodec().decode(tempBuf) : null;
            if (msg == null) break;
            final Object theMsg = msg;
            this.dispatcherManager.getExecutor().execute(new Runnable(){

                public void run() {
                    try {
                        Session.this.eventAdaptor.onMessage(theMsg, Session.this);
                    }
                    catch (Throwable e) {
                        try {
                            Session.this.eventAdaptor.onException(e, Session.this);
                        }
                        catch (IOException e1) {
                            try {
                                Session.this.close();
                            }
                            catch (Throwable e2) {
                                log.error(e2.getMessage(), e2);
                            }
                        }
                    }
                }
            });
        }
        tempBuf.reset();
        this.readBuffer = this.resetIoBuffer(tempBuf);
    }

    protected IoBuffer resetIoBuffer(IoBuffer buffer) {
        IoBuffer newBuffer = null;
        if (buffer != null && buffer.remaining() > 0) {
            int len = buffer.remaining();
            byte[] bb = new byte[len];
            buffer.get(bb);
            newBuffer = IoBuffer.wrap(bb);
            newBuffer.position(len);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWrite() throws IOException {
        int n = 0;
        Queue<ByteBuffer> queue = this.writeBufferQ;
        synchronized (queue) {
            while (true) {
                ByteBuffer buf;
                if ((buf = this.writeBufferQ.peek()) == null) {
                    this.registeredKey.interestOps(1);
                    break;
                }
                int wbytes = this.channel.write(buf);
                if (wbytes == 0 && buf.remaining() > 0) break;
                n += wbytes;
                if (buf.remaining() != 0) break;
                this.writeBufferQ.remove();
            }
        }
        return n;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Session) {
            Session other = (Session)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public long getLastOperationTime() {
        return this.lastOperationTime;
    }

    public void updateLastOperationTime() {
        this.lastOperationTime = System.currentTimeMillis();
    }

    public String getRemoteAddress() {
        if (this.status != SessionStatus.CLOSED) {
            InetAddress addr = this.channel.socket().getInetAddress();
            return String.format("%s:%d", addr.getHostAddress(), this.channel.socket().getPort());
        }
        return null;
    }

    public String getLocalAddress() {
        if (this.status != SessionStatus.CLOSED) {
            return Helper.localAddress(this.channel);
        }
        return null;
    }

    public int interestOps() throws IOException {
        if (this.registeredKey == null) {
            throw new IOException("Session not registered yet:" + this);
        }
        return this.registeredKey.interestOps();
    }

    public void register(int interestOps) throws IOException {
        this.dispatcherManager.registerSession(interestOps, this);
    }

    public void interestOps(int ops) {
        if (this.registeredKey == null) {
            throw new IllegalStateException("registered session required");
        }
        this.registeredKey.interestOps(ops);
    }

    public void interestOpsAndWakeup(int ops) {
        this.interestOps(ops);
        this.registeredKey.selector().wakeup();
    }

    public SelectionKey getRegisteredKey() {
        return this.registeredKey;
    }

    public void setRegisteredKey(SelectionKey key) {
        this.registeredKey = key;
    }

    public SessionStatus getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.status == SessionStatus.CONNECTED;
    }

    public boolean isNew() {
        return this.status == SessionStatus.NEW;
    }

    public void setStatus(SessionStatus status) {
        this.status = status;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public DispatcherManager dispatcherManager() {
        return this.dispatcherManager;
    }

    public void finishConnect() {
        this.connectLatch.countDown();
    }

    public boolean waitToConnect(long millis) {
        try {
            return this.connectLatch.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public <T> T attr(String key) {
        if (this.attributes == null) {
            return null;
        }
        return (T)this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void attr(String key, T value) {
        if (this.attributes == null) {
            Session session = this;
            synchronized (session) {
                if (this.attributes == null) {
                    this.attributes = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        this.attributes.put(key, value);
    }

    public String toString() {
        return "Session [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", registeredKey=" + this.registeredKey + ", attributes=" + this.attributes + ", lastOperationTime=" + this.lastOperationTime + ", readBuffer=" + this.readBuffer + ", writeBufferQ=" + this.writeBufferQ + ", connectLatch=" + this.connectLatch + ", channel=" + this.channel + "]";
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public EventAdaptor getEventAdaptor() {
        return this.eventAdaptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionStatus {
        NEW,
        CONNECTED,
        ON_ERROR,
        CLOSED;

    }
}

