/*
 * Decompiled with CFR 0.152.
 */
package org.zbus.remoting.ticket;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.zbus.remoting.Message;
import org.zbus.remoting.ticket.ResultCallback;
import org.zbus.remoting.ticket.Ticket;

public class TicketManager {
    private static ConcurrentMap<String, Ticket> tickets = new ConcurrentHashMap<String, Ticket>();
    private static ScheduledExecutorService ticketThread = Executors.newSingleThreadScheduledExecutor();

    static void norun() {
        ticketThread.scheduleAtFixedRate(new Runnable(){
            long currentTime = -1L;

            public void run() {
                Collection values = tickets.values();
                this.currentTime = System.currentTimeMillis();
                for (Ticket t : values) {
                    if (this.currentTime - t.startTime <= t.timeout) continue;
                    TicketManager.removeTicket(t.getId());
                    t.expired();
                }
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    public static void shutdown() {
        ticketThread.shutdown();
    }

    public static Ticket getTicket(String id) {
        if (id == null) {
            return null;
        }
        return (Ticket)tickets.get(id);
    }

    public static Ticket createTicket(Message req, long timeout) {
        return TicketManager.createTicket(req, timeout, null);
    }

    public static Ticket createTicket(Message req, long timeout, ResultCallback callback) {
        Ticket ticket = new Ticket(req, timeout);
        ticket.setCallback(callback);
        if (tickets.putIfAbsent(ticket.getId(), ticket) != null) {
            throw new IllegalArgumentException("duplicate ticket number.");
        }
        return ticket;
    }

    public static void removeTicket(String id) {
        tickets.remove(id);
    }
}

