/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.chatant;

import java.io.InputStream;
import java.util.function.Consumer;
import org.zenoda.chatant.PartialMessage;
import org.zenoda.chatant.message.AssistantMessage;

public abstract class ChatResponse {
    private String conversationId;
    private InputStream stream;
    private Throwable error;
    private Consumer<PartialMessage> messageConsumer;
    private Consumer<AssistantMessage> completeConsumer;
    private Consumer<Error> errorConsumer;

    protected String getConversationId() {
        return this.conversationId;
    }

    protected Throwable getError() {
        return this.error;
    }

    protected InputStream getStream() {
        return this.stream;
    }

    protected Consumer<PartialMessage> getMessageConsumer() {
        return this.messageConsumer;
    }

    protected Consumer<AssistantMessage> getCompleteConsumer() {
        return this.completeConsumer;
    }

    protected Consumer<Error> getErrorConsumer() {
        return this.errorConsumer;
    }

    public ChatResponse onError(Consumer<Error> errorConsumer) {
        this.errorConsumer = errorConsumer;
        return this;
    }

    public ChatResponse onMessage(Consumer<PartialMessage> messageConsumer) {
        this.messageConsumer = messageConsumer;
        return this;
    }

    public ChatResponse onComplete(Consumer<AssistantMessage> completeConsumer) {
        this.completeConsumer = completeConsumer;
        return this;
    }

    public abstract void subscribe();

    public static abstract class Builder {
        private String conversationId;
        private InputStream stream;
        private Throwable error;

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder stream(InputStream stream) {
            this.stream = stream;
            return this;
        }

        public Builder error(Throwable error) {
            this.error = error;
            return this;
        }

        protected ChatResponse _build(ChatResponse response) {
            response.stream = this.stream;
            response.error = this.error;
            response.conversationId = this.conversationId;
            return response;
        }

        public abstract ChatResponse build();
    }
}

