/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.chatant.adaptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zenoda.chatant.ChatMemory;
import org.zenoda.chatant.ChatMessage;

public class SimpleChatMemory
implements ChatMemory {
    private static int historySize = 10;
    private final Map<String, List<ChatMessage>> memory = new HashMap<String, List<ChatMessage>>();

    @Override
    public void addMessage(String conversationId, ChatMessage message) {
        List<ChatMessage> messages = this.memory.get(conversationId);
        if (messages == null) {
            messages = new ArrayList<ChatMessage>();
            this.memory.put(conversationId, messages);
        }
        messages.add(message);
        while (messages.size() > historySize) {
            messages.removeFirst();
        }
    }

    @Override
    public List<ChatMessage> getMessages(String conversationId) {
        return this.memory.get(conversationId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public SimpleChatMemory build() {
            return new SimpleChatMemory();
        }
    }
}

