/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.chatant;

import java.net.http.HttpRequest;
import java.util.List;
import org.zenoda.chatant.ChatMessage;
import org.zenoda.chatant.ChatResponse;
import org.zenoda.chatant.ToolSpecification;

public abstract class ChatRequest {
    private String baseUrl;
    private String apiKey;
    private String modelName;
    private Float temperature;
    private Integer topK;
    private Float topP;
    private Integer seed;
    private Long maxTokens;
    private Integer timeout;
    private String conversationId;
    private List<? extends ChatMessage> messages;
    private List<ToolSpecification> tools;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public Long getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Long maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public List<? extends ChatMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<? extends ChatMessage> messages) {
        this.messages = messages;
    }

    public List<ToolSpecification> getTools() {
        return this.tools;
    }

    public void setTools(List<ToolSpecification> tools) {
        this.tools = tools;
    }

    public abstract HttpRequest buildHttpRequest();

    public abstract ChatResponse.Builder responseBuilder();

    public static abstract class Builder {
        protected String baseUrl;
        protected String apiKey;
        protected String modelName;
        protected Float temperature;
        protected Integer topK;
        protected Float topP;
        protected Integer seed;
        protected Long maxTokens;
        protected Integer timeout;
        protected String conversationId;
        protected List<? extends ChatMessage> messages;
        protected List<ToolSpecification> tools;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder temperature(float temperature) {
            this.temperature = Float.valueOf(temperature);
            return this;
        }

        public Builder topK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder topP(float topP) {
            this.topP = Float.valueOf(topP);
            return this;
        }

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder maxTokens(long maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder messages(List<? extends ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder tools(List<ToolSpecification> tools) {
            this.tools = tools;
            return this;
        }

        protected void _build(ChatRequest chatRequest) {
            chatRequest.baseUrl = this.baseUrl;
            chatRequest.apiKey = this.apiKey;
            chatRequest.modelName = this.modelName;
            chatRequest.temperature = this.temperature;
            chatRequest.topK = this.topK;
            chatRequest.topP = this.topP;
            chatRequest.seed = this.seed;
            chatRequest.maxTokens = this.maxTokens;
            chatRequest.timeout = this.timeout;
            chatRequest.conversationId = this.conversationId;
            chatRequest.messages = this.messages;
            chatRequest.tools = this.tools;
        }

        public abstract ChatRequest build();
    }
}

