/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.chatant;

import java.io.InputStream;
import java.util.function.Consumer;
import org.zenoda.chatant.PartialMessage;
import org.zenoda.chatant.message.AssistantMessage;

public abstract class ChatResponse {
    private InputStream inputStream;
    private Boolean streaming;
    private Throwable error;
    private Consumer<PartialMessage> messageConsumer;
    private Consumer<AssistantMessage> completeConsumer;

    protected Boolean getStreaming() {
        return this.streaming;
    }

    protected Throwable getError() {
        return this.error;
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected Consumer<PartialMessage> getMessageConsumer() {
        return this.messageConsumer;
    }

    protected Consumer<AssistantMessage> getCompleteConsumer() {
        return this.completeConsumer;
    }

    public ChatResponse onMessage(Consumer<PartialMessage> messageConsumer) {
        this.messageConsumer = messageConsumer;
        return this;
    }

    public ChatResponse onComplete(Consumer<AssistantMessage> completeConsumer) {
        this.completeConsumer = completeConsumer;
        return this;
    }

    public abstract void subscribe();

    public static abstract class Builder {
        private InputStream inputStream;
        private Boolean streaming;
        private Throwable error;

        public Builder streaming(Boolean streaming) {
            this.streaming = streaming;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder error(Throwable error) {
            this.error = error;
            return this;
        }

        protected void _build(ChatResponse response) {
            response.inputStream = this.inputStream;
            response.streaming = this.streaming;
            response.error = this.error;
        }

        public abstract ChatResponse build();
    }
}

