/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.chatant.adaptor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.http.HttpRequest;
import org.zenoda.chatant.ChatRequest;
import org.zenoda.chatant.ChatResponse;
import org.zenoda.chatant.ChatRole;
import org.zenoda.chatant.MediaType;
import org.zenoda.chatant.adaptor.OpenaiChatResponse;
import org.zenoda.chatant.message.AssistantMessage;
import org.zenoda.chatant.message.SystemMessage;
import org.zenoda.chatant.message.ToolMessage;
import org.zenoda.chatant.message.UserMessage;

public class OpenaiChatRequest
extends ChatRequest {
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ChatResponse.Builder responseBuilder() {
        return OpenaiChatResponse.builder();
    }

    private String mapRole(ChatRole role) {
        return switch (role) {
            case ChatRole.TOOL -> "tool";
            case ChatRole.USER -> "user";
            case ChatRole.ASSISTANT -> "assistant";
            case ChatRole.SYSTEM -> "system";
            default -> "unknown";
        };
    }

    private String createRequestBody() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode requestJsonNode = mapper.createObjectNode().put("model", this.getModelName()).put("stream", this.getStreaming());
        if (this.getTemperature() != null) {
            requestJsonNode.put("temperature", this.getTemperature());
        }
        if (this.getTopP() != null) {
            requestJsonNode.put("top_p", this.getTopP());
        }
        if (this.getSeed() != null) {
            requestJsonNode.put("seed", this.getSeed());
        }
        if (this.getMaxTokens() != null) {
            requestJsonNode.put("max_tokens", this.getMaxTokens());
        }
        if (this.getTimeout() != null) {
            requestJsonNode.put("timeout", this.getTimeout());
        }
        ArrayNode messageArrayNode = requestJsonNode.putArray("messages");
        this.getMessages().forEach(message -> {
            ObjectNode messageJsonNode = mapper.createObjectNode().put("role", this.mapRole(message.getRole()));
            if (message.getRole() == ChatRole.USER) {
                UserMessage userMessage = (UserMessage)message;
                if (userMessage.getMediaList() == null || userMessage.getMediaList().isEmpty()) {
                    messageJsonNode.put("content", userMessage.getContent());
                } else {
                    ArrayNode contentArrayNode = messageJsonNode.putArray("content");
                    userMessage.getMediaList().forEach(media -> {
                        ObjectNode mediaContentJsonNode = mapper.createObjectNode();
                        if (media.getType() == MediaType.IMAGE) {
                            mediaContentJsonNode.put("type", "image_url");
                            ObjectNode imageUrlJsonNode = mediaContentJsonNode.putObject("image_url");
                            imageUrlJsonNode.put("url", media.getUrl());
                        } else if (media.getType() == MediaType.AUDIO) {
                            mediaContentJsonNode.put("type", "input_audio");
                            ObjectNode inputAudioJsonNode = mediaContentJsonNode.putObject("input_audio");
                            inputAudioJsonNode.put("data", media.getUrl());
                        } else if (media.getType() == MediaType.VIDEO) {
                            mediaContentJsonNode.put("type", "video_url");
                            ObjectNode videoUrlJsonNode = mediaContentJsonNode.putObject("video_url");
                            videoUrlJsonNode.put("url", media.getUrl());
                        }
                        contentArrayNode.add((JsonNode)mediaContentJsonNode);
                    });
                    ObjectNode textContentJsonNode = mapper.createObjectNode();
                    textContentJsonNode.put("type", "text");
                    textContentJsonNode.put("text", userMessage.getContent());
                    contentArrayNode.add((JsonNode)textContentJsonNode);
                }
            } else if (message.getRole() == ChatRole.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                messageJsonNode.put("content", assistantMessage.getContent());
                messageJsonNode.put("reasoning_content", assistantMessage.getReasoningContent());
                if (assistantMessage.getToolCalls() != null && !assistantMessage.getToolCalls().isEmpty()) {
                    ArrayNode toolCallsNode = messageJsonNode.putArray("tool_calls");
                    assistantMessage.getToolCalls().forEach(toolCall -> {
                        ObjectNode toolCallNode = mapper.createObjectNode();
                        toolCallsNode.add((JsonNode)toolCallNode);
                        toolCallNode.put("id", toolCall.getId()).put("index", toolCall.getIndex()).put("type", "function");
                        ObjectNode functionNode = toolCallNode.putObject("function");
                        functionNode.put("name", toolCall.getFunction()).put("arguments", toolCall.getArguments());
                    });
                }
            } else if (message.getRole() == ChatRole.SYSTEM) {
                SystemMessage systemMessage = (SystemMessage)message;
                messageJsonNode.put("content", systemMessage.getContent());
            } else if (message.getRole() == ChatRole.TOOL) {
                ToolMessage toolMessage = (ToolMessage)message;
                messageJsonNode.put("content", toolMessage.getContent()).put("tool_call_id", toolMessage.getToolCallId());
            }
            messageArrayNode.add((JsonNode)messageJsonNode);
        });
        if (this.getTools() != null && !this.getTools().isEmpty()) {
            ArrayNode toolArrayNode = requestJsonNode.putArray("tools");
            this.getTools().forEach(tool -> {
                ObjectNode toolNode = mapper.createObjectNode();
                toolNode.put("type", "function");
                ObjectNode functionNode = mapper.createObjectNode();
                functionNode.put("name", tool.getName());
                functionNode.put("description", tool.getDescription());
                functionNode.put("parameters", (JsonNode)tool.getParameters());
                toolNode.put("function", (JsonNode)functionNode);
                toolArrayNode.add((JsonNode)toolNode);
            });
        }
        return requestJsonNode.toString();
    }

    @Override
    public HttpRequest buildHttpRequest() {
        return HttpRequest.newBuilder().uri(URI.create(this.getBaseUrl() + "/chat/completions")).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.getApiKey()).POST(HttpRequest.BodyPublishers.ofString(this.createRequestBody())).build();
    }

    public static class Builder
    extends ChatRequest.Builder {
        @Override
        public ChatRequest build() {
            OpenaiChatRequest chatRequest = new OpenaiChatRequest();
            this._build(chatRequest);
            return chatRequest;
        }
    }
}

