/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.chatant.adaptor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.zenoda.chatant.ChatResponse;
import org.zenoda.chatant.ToolCallSpecification;
import org.zenoda.chatant.message.AssistantMessage;
import org.zenoda.chatant.message.ErrorPartialMessage;
import org.zenoda.chatant.message.ResultPartialMessage;
import org.zenoda.chatant.message.ThinkingPartialMessage;
import org.zenoda.chatant.message.ToolCallPartialMessage;

public class OpenaiChatResponse
extends ChatResponse {
    private ObjectMapper objectMapper = new ObjectMapper();

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void subscribe() {
        if (this.getError() != null) {
            this.getMessageConsumer().accept(ErrorPartialMessage.builder().error(this.getError().getMessage()).build());
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(), StandardCharsets.UTF_8));){
                AssistantMessage assistantMessage = null;
                assistantMessage = this.getStreaming() != false ? this.readStreaming(reader) : this.readBlock(reader);
                this.getCompleteConsumer().accept(assistantMessage);
            }
            catch (Exception e) {
                this.getMessageConsumer().accept(ErrorPartialMessage.builder().error(e.getMessage()).build());
            }
        }
    }

    private AssistantMessage readBlock(BufferedReader reader) throws IOException {
        JsonNode rootNode = this.objectMapper.readTree((Reader)reader);
        ObjectNode messageNode = (ObjectNode)rootNode.get("choices").get(0).get("message");
        List<ToolCallSpecification> toolCalls = Optional.ofNullable(messageNode.get("tool_calls")).orElse((JsonNode)this.objectMapper.createArrayNode()).valueStream().map(toolCallNode -> ToolCallSpecification.builder().id(toolCallNode.get("id").asText()).index(toolCallNode.get("index").asInt()).function(toolCallNode.get("function").get("name").asText()).arguments(toolCallNode.get("function").get("arguments").asText()).build()).toList();
        return AssistantMessage.builder().content(messageNode.get("content").asText()).toolCalls(toolCalls).build();
    }

    private AssistantMessage readStreaming(BufferedReader reader) throws IOException {
        AssistantMessage assistantMessage = AssistantMessage.builder().build();
        reader.lines().forEach(line -> {
            if ((line = line.trim()).isEmpty()) {
                return;
            }
            try {
                if (line.startsWith("data:")) {
                    if ((line = line.substring("data:".length()).trim()).equals("[DONE]")) {
                        return;
                    }
                    ObjectNode data = (ObjectNode)this.objectMapper.readValue(line, ObjectNode.class);
                    ArrayNode choices = (ArrayNode)data.get("choices");
                    if (choices != null && !choices.isEmpty()) {
                        ObjectNode choice0 = (ObjectNode)choices.get(0);
                        ObjectNode delta = (ObjectNode)choice0.get("delta");
                        String thinkingText = Optional.ofNullable(delta.get("reasoning_content")).orElse((JsonNode)NullNode.getInstance()).asText("");
                        String resultText = Optional.ofNullable(delta.get("content")).orElse((JsonNode)NullNode.getInstance()).asText("");
                        ArrayNode toolCalls = (ArrayNode)delta.get("tool_calls");
                        if (!thinkingText.isEmpty()) {
                            assistantMessage.setReasoningContent(Optional.ofNullable(assistantMessage.getReasoningContent()).orElse("") + thinkingText);
                            this.getMessageConsumer().accept(ThinkingPartialMessage.builder().text(thinkingText).build());
                        } else if (!resultText.isEmpty()) {
                            assistantMessage.setContent(Optional.ofNullable(assistantMessage.getContent()).orElse("") + resultText);
                            this.getMessageConsumer().accept(ResultPartialMessage.builder().text(resultText).build());
                        } else if (toolCalls != null && !toolCalls.isEmpty()) {
                            toolCalls.valueStream().map(toolCall -> {
                                int index = toolCall.get("index").asInt();
                                if (assistantMessage.getToolCalls() == null) {
                                    assistantMessage.setToolCalls(new ArrayList<ToolCallSpecification>());
                                }
                                ToolCallSpecification toolCallSpecification = assistantMessage.getToolCalls().stream().filter(tcs -> tcs.getIndex() == index).findFirst().orElse(null);
                                String partialArguments = Optional.ofNullable(toolCall.get("function").get("arguments")).orElse((JsonNode)NullNode.getInstance()).asText(null);
                                if (toolCallSpecification == null) {
                                    toolCallSpecification = ToolCallSpecification.builder().index(index).id(toolCall.get("id").asText()).function(toolCall.get("function").get("name").asText()).arguments(partialArguments).build();
                                    assistantMessage.getToolCalls().add(toolCallSpecification);
                                } else if (partialArguments != null) {
                                    toolCallSpecification.setArguments(toolCallSpecification.getArguments() + partialArguments);
                                }
                                return ToolCallPartialMessage.builder().index(toolCall.get("index").asInt()).id(toolCallSpecification.getId()).name(toolCallSpecification.getFunction()).partialArguments(partialArguments).build();
                            }).forEach(this.getMessageConsumer());
                        }
                    }
                } else {
                    this.getMessageConsumer().accept(ErrorPartialMessage.builder().error("Data format is abnormal: " + line).build());
                }
            }
            catch (Exception e) {
                this.getMessageConsumer().accept(ErrorPartialMessage.builder().error(e.getMessage()).build());
            }
        });
        return assistantMessage;
    }

    public static class Builder
    extends ChatResponse.Builder {
        @Override
        public OpenaiChatResponse build() {
            OpenaiChatResponse response = new OpenaiChatResponse();
            this._build(response);
            return response;
        }
    }
}

