/*
 * Decompiled with CFR 0.152.
 */
package org.zenoda.chatant.message;

import java.util.List;
import org.zenoda.chatant.ChatMessage;
import org.zenoda.chatant.ChatRole;
import org.zenoda.chatant.ToolCallSpecification;

public class AssistantMessage
extends ChatMessage {
    private List<ToolCallSpecification> toolCalls;
    private String reasoningContent;

    public AssistantMessage() {
        this.setRole(ChatRole.ASSISTANT);
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public void setReasoningContent(String reasoningContent) {
        this.reasoningContent = reasoningContent;
    }

    public List<ToolCallSpecification> getToolCalls() {
        return this.toolCalls;
    }

    public void setToolCalls(List<ToolCallSpecification> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssistantMessage [role=").append((Object)this.getRole()).append(", reasoningContent=").append(this.getReasoningContent()).append(", content=").append(this.getContent()).append(", toolCalls=").append(this.getToolCalls()).append("]");
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ChatMessage.Builder {
        private List<ToolCallSpecification> toolCalls;
        private String reasoningContent;

        public Builder toolCalls(List<ToolCallSpecification> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        @Override
        public Builder content(String content) {
            super.content(content);
            return this;
        }

        public Builder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        @Override
        public AssistantMessage build() {
            AssistantMessage message = new AssistantMessage();
            this._build(message);
            message.setToolCalls(this.toolCalls);
            message.setReasoningContent(this.reasoningContent);
            return message;
        }
    }
}

